/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.sql;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Task;

public class AntReadBlob
extends Task {
    private String className;
    private String jdbcUrl;
    private String user;
    private String password;
    private String extension;
    private String sql;
    private String outputDirectory;
    private boolean unzip;
    private static final int NAME = 1;
    private static final int BLOB = 2;
    private static final int KBYTES = 1024;
    private static Logger logger = Logger.getLogger(AntReadBlob.class);

    public AntReadBlob() {
    }

    public AntReadBlob(String className, String jdbcUrl, String user, String password, String extension, String sql, String outputDirectory, boolean unzip) {
        this.setClassName(className);
        this.setJdbcUrl(jdbcUrl);
        this.setUser(user);
        this.setPassword(password);
        this.setExtension(extension);
        this.setSql(sql);
        this.setOutputDirectory(outputDirectory);
        this.setUnzip(unzip);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isUnzip() {
        return this.unzip;
    }

    public void setUnzip(boolean unzip) {
        this.unzip = unzip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Connection conn = null;
        try {
            logger.debug((Object)("Trying to load " + this.getClassName()));
            Class.forName(this.getClassName());
            logger.trace((Object)("Trying to connect using + " + this.getJdbcUrl()));
            conn = DriverManager.getConnection(this.getJdbcUrl(), this.getUser(), this.getPassword());
            logger.trace((Object)("Trying to run + " + this.getSql()));
            PreparedStatement stmt = conn.prepareStatement(this.getSql());
            ResultSet resultSet = stmt.executeQuery();
            logger.debug((Object)("Extracting resultset. Number of records - " + resultSet.getFetchSize()));
            while (resultSet.next()) {
                logger.trace((Object)("Name - " + resultSet.getString(1)));
                String name = resultSet.getString(1);
                String fileName = this.getOutputDirectory() + File.separator + name + this.getExtension();
                logger.debug((Object)("Filename outputing to - " + fileName));
                File file = new File(fileName);
                FileOutputStream fos = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                logger.debug((Object)("Unzip is " + this.isUnzip()));
                if (this.isUnzip()) {
                    logger.trace((Object)"Trying to extract blob");
                    ZipInputStream zis = new ZipInputStream(resultSet.getBinaryStream(2));
                    ZipEntry ze = zis.getNextEntry();
                    if (ze != null) {
                        int len;
                        logger.trace((Object)"Extracting zip");
                        logger.trace((Object)"Writing out file");
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                } else {
                    InputStream is = resultSet.getBinaryStream(2);
                    while (is.read(buffer) > 0) {
                        fos.write(buffer);
                    }
                }
                fos.close();
            }
            resultSet.close();
            stmt.close();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

