/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.log4j.Logger;

public class CsvToExcel {
    private String outputFile;
    private String[] inputFile;
    private String baseDir;
    private char separator = (char)44;
    private static final int MAX_FILE_LENGTH = 12;
    private static final int MAX_EXCEL_ROW = 64000;
    private static Logger logger = Logger.getLogger(CsvToExcel.class);

    public CsvToExcel(String[] inputFile, String outputFile, String baseDir) {
        this.setInputFile(inputFile);
        this.setOutputFile(outputFile);
        this.setBaseDir(baseDir);
    }

    public CsvToExcel(String[] inputFile, String outputFile, String baseDir, char separator) {
        this.setInputFile(inputFile);
        this.setOutputFile(outputFile);
        this.setBaseDir(baseDir);
        this.setSeparator(separator);
    }

    public CsvToExcel(String[] inputFile, String outputFile, char separator) {
        this.setInputFile(inputFile);
        this.setOutputFile(outputFile);
        this.setSeparator(separator);
    }

    public void setSeparator(char separator) {
        logger.trace((Object)("Setting separator to " + separator));
        this.separator = separator;
    }

    public void setBaseDir(String baseDir) {
        logger.trace((Object)("Setting basedir to " + baseDir));
        this.baseDir = baseDir;
    }

    public void setOutputFile(String outputFile) {
        logger.trace((Object)("Setting outputFile to " + outputFile));
        this.outputFile = outputFile;
    }

    public void setInputFile(String[] inputFile) {
        logger.trace((Object)("Setting inputFile to " + inputFile));
        this.inputFile = (String[])inputFile.clone();
    }

    public static WritableWorkbook createWorkbook(String outputFile) throws IOException {
        logger.trace((Object)("Initialising oFile " + outputFile));
        File oFile = new File(outputFile);
        return Workbook.createWorkbook((File)oFile);
    }

    public void execute() throws IOException, WriteException {
        WritableWorkbook workbook = CsvToExcel.createWorkbook(this.outputFile);
        for (int i = 0; i < this.inputFile.length; ++i) {
            String[] line;
            String filename = this.inputFile[i];
            logger.debug((Object)("Processing " + filename));
            String name = filename;
            if (name.length() > 12) {
                name = name.substring(0, 12);
            }
            CSVReader reader = this.baseDir != null ? new CSVReader((Reader)new FileReader(this.baseDir + File.separator + filename), this.separator) : new CSVReader((Reader)new FileReader(filename), this.separator);
            WritableSheet s = workbook.createSheet(name, 0);
            int row = 0;
            int count = 1;
            while ((line = reader.readNext()) != null) {
                logger.debug((Object)("Line read " + line));
                for (int column = 0; column < line.length; ++column) {
                    String columnText = line[column];
                    logger.trace((Object)("TOKEN - " + columnText));
                    if (columnText.length() <= 0) continue;
                    s.addCell((WritableCell)new Label(column, row, columnText));
                }
                if (++row < 64000) continue;
                logger.trace((Object)("Moving to the next sheet " + name + "_sheet" + count));
                s = workbook.createSheet(name + "_sheet" + count++, 0);
            }
            reader.close();
        }
        workbook.write();
        workbook.close();
    }
}

