/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AntXMLUnit
extends Task {
    Logger logger = Logger.getLogger(AntXMLUnit.class);
    private Vector<FileSet> fileSets = new Vector();
    private String testDirectory;
    private String resultDirectory;
    private String separator = ",";
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private static List<Integer> ignoreIds = new ArrayList<Integer>();

    public void addFileSet(FileSet fileset) {
        if (!this.fileSets.contains(fileset)) {
            this.fileSets.add(fileset);
        }
    }

    public void setTestDirectory(String testDirectory) {
        this.testDirectory = testDirectory;
    }

    public void setResultDirectory(String resultDirectory) {
        this.resultDirectory = resultDirectory;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    private DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.factory == null) {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setNamespaceAware(true);
        }
        return this.factory;
    }

    private DocumentBuilder getBuilder() throws ParserConfigurationException {
        if (this.builder == null) {
            this.builder = this.getDocumentBuilderFactory().newDocumentBuilder();
        }
        return this.builder;
    }

    public void execute() {
        File testDir = new File(this.testDirectory);
        if (!testDir.exists()) {
            this.logger.error((Object)(this.testDirectory + " does not exist"));
            System.exit(1);
        }
        this.preSetup();
        for (FileSet fileset : this.fileSets) {
            String[] filesInSet;
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            File controlDir = ds.getBasedir();
            for (String fileName : filesInSet = ds.getIncludedFiles()) {
                this.log("Processing " + fileName);
                try {
                    File controlFile = new File(controlDir, fileName);
                    File testFile = new File(testDir, fileName);
                    List<Difference> differences = this.processFile(controlFile, testFile);
                    this.writeReport(differences, controlFile);
                }
                catch (ParserConfigurationException e) {
                    this.logger.error((Object)"Unable setup dependencies");
                    this.logger.error((Object)e);
                }
                catch (IOException e) {
                    this.logger.error((Object)("Unable to process - " + fileName));
                    this.logger.error((Object)e);
                }
                catch (SAXException e) {
                    this.logger.error((Object)("Unable to read either control/test file " + fileName));
                    this.logger.error((Object)e);
                }
            }
        }
    }

    public void preSetup() {
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        ignoreIds.add(new Integer(20));
    }

    public List<Difference> processFile(File controlFile, File testFile) throws IOException, SAXException, ParserConfigurationException {
        this.builder = this.getBuilder();
        Document control = this.builder.parse(controlFile);
        Document test = this.builder.parse(testFile);
        Diff diff = new Diff(control, test);
        DetailedDiff dd = new DetailedDiff(diff);
        return dd.getAllDifferences();
    }

    public void writeReport(List<Difference> differences, File controlFile) throws IOException {
        BufferedWriter report = new BufferedWriter(new FileWriter(this.resultDirectory + "/" + controlFile.getName() + ".csv"));
        String header = "Diff ID" + this.separator + "Description" + this.separator + "Control Value" + this.separator + "Test Value" + this.separator + "XPath" + "\n";
        report.write(header);
        for (Difference differenceObject : differences) {
            Difference difference = differenceObject;
            if (ignoreIds.contains(new Integer(difference.getId()))) {
                this.logger.debug((Object)("SKIP - " + difference.getId() + this.separator + difference.getDescription() + this.separator + difference.getControlNodeDetail().getXpathLocation()));
                continue;
            }
            String differenceString = difference.getId() + this.separator + difference.getDescription() + this.separator + difference.getControlNodeDetail().getValue() + this.separator + difference.getTestNodeDetail().getValue() + this.separator + difference.getControlNodeDetail().getXpathLocation();
            report.write(differenceString + "\n");
            this.logger.debug((Object)("DIFF - " + differenceString));
        }
        if (differences.size() == 0) {
            this.logger.info((Object)(controlFile.getAbsolutePath() + "/" + controlFile.getName() + "No difference found"));
        }
        ((Writer)report).close();
    }
}

