/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.csv;

import java.io.File;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import uk.co.firstzero.csv.CsvToExcel;

public class AntCsvToExcel
extends Task {
    private static Logger logger = Logger.getLogger(AntCsvToExcel.class);
    private Vector<FileSet> fileSets = new Vector();
    private String outputFile;
    private char separator = (char)44;

    public void addFileSet(FileSet fileset) {
        if (!this.fileSets.contains(fileset)) {
            this.fileSets.add(fileset);
        }
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void execute() {
        int count = 0;
        for (FileSet fileset : this.fileSets) {
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] filesInSet = ds.getIncludedFiles();
            String oFile = this.outputFile;
            if (count > 1) {
                oFile = new File(this.outputFile).getName() + "_" + count + ".xls";
            }
            try {
                CsvToExcel csv = new CsvToExcel(filesInSet, oFile, ds.getBasedir().toString(), this.separator);
                csv.execute();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to process ");
                logger.error((Object)e);
            }
            ++count;
        }
    }
}

