/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.webdav;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Task;
import uk.co.firstzero.webdav.Common;

public class Pull
extends Task {
    private static Logger logger = Logger.getLogger(Pull.class);
    private String user;
    private String password;
    private String url;
    private String file;
    private String outFile;
    private String proxyUser;
    private String proxyPassword;
    private String proxyHost;
    private int proxyPort = Integer.MIN_VALUE;
    private boolean overwrite = false;
    private HttpClient httpClient;
    private static final int MILLISECONDS_TO_SECONDS = 1000;

    public Pull() {
    }

    public Pull(String user, String password, String url, String fileToDownload) {
        this.setUser(user);
        this.setPassword(password);
        this.setUrl(url);
        this.setFile(fileToDownload);
    }

    public Pull(String user, String password, String url, String fileToDownload, String outputFile) throws MalformedURLException {
        this.setUser(user);
        this.setPassword(password);
        this.setUrl(url);
        this.setFile(fileToDownload);
        this.setOutFile(outputFile);
        this.setUp();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        logger.trace((Object)("User is " + this.user));
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        logger.trace((Object)("password is " + this.password));
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        logger.trace((Object)("url is " + this.url));
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
        logger.trace((Object)("file is " + this.file));
        if (this.outFile == null) {
            this.outFile = file;
        }
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
        logger.trace((Object)("outFile is " + this.outFile));
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        logger.trace((Object)("overwrite is " + this.overwrite));
    }

    public String getProyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        logger.trace((Object)("proxyHost is " + this.proxyHost));
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        logger.trace((Object)("proxyHost is " + this.proxyPort));
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        logger.trace((Object)("proxyHost is " + this.proxyUser));
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        logger.trace((Object)("proxyHost is " + this.proxyPassword));
    }

    public void setUp() throws MalformedURLException {
        logger.trace((Object)"Setting up setUp");
        this.httpClient = new HttpClient();
        this.httpClient = Common.setProxy(this.httpClient, this.getProyHost(), this.getProxyPort(), this.getProxyUser(), this.getProxyPassword());
        this.httpClient = Common.setCredentials(this.httpClient, this.getUrl(), this.getUser(), this.getPassword());
        logger.trace((Object)"Completed setup");
    }

    public boolean download() throws IOException {
        this.setUp();
        File oFile = new File(this.getOutFile());
        long startTime = System.currentTimeMillis();
        logger.trace((Object)("Started time - startTime - " + startTime));
        boolean completed = false;
        if (this.getOverwrite() || !oFile.exists()) {
            if (oFile.exists()) {
                logger.debug((Object)("Overwriting " + oFile.getAbsolutePath()));
            }
            logger.debug((Object)("Downloading " + this.getUrl() + "/" + this.getFile() + " to " + oFile.getAbsolutePath()));
            GetMethod method = new GetMethod(this.url + "/" + this.getFile());
            this.httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                throw new IOException(method.getStatusCode() + " " + method.getStatusText() + " " + method.getResponseBodyAsString() + " " + Arrays.toString(method.getResponseHeaders()));
            }
            this.writeFile(method.getResponseBodyAsStream(), oFile);
            long elapsed = (System.currentTimeMillis() - startTime) / 1000L;
            logger.debug((Object)(this.getFile() + " took " + elapsed + " seconds to complete"));
            completed = true;
        } else {
            logger.debug((Object)("Skipping - overwrite not allowed for " + this.getFile()));
        }
        return completed;
    }

    public void execute() {
        boolean status = false;
        try {
            status = this.download();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        String message = status ? "Download successful" : "Download failed";
        logger.info((Object)message);
        if (status) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public void writeFile(InputStream inputStream, File outFile) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(outFile);
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
            out.flush();
        }
        ((OutputStream)out).close();
    }
}

