/*
 * Decompiled with CFR 0.152.
 */
package uk.num.punycode;

import uk.num.punycode.PunycodeFunctions;

public class Punycode {
    public static String decode(String input) {
        int index;
        StringBuilder output = new StringBuilder();
        int inputLength = input.length();
        int i = 0;
        int n = 128;
        int bias = 72;
        int basic = input.lastIndexOf(45);
        if (basic < 0) {
            basic = 0;
        }
        for (int j = 0; j < basic; ++j) {
            if (input.charAt(j) >= '\u0080') {
                PunycodeFunctions.error("not-basic");
            }
            output.append(input.charAt(j));
        }
        int n2 = index = basic > 0 ? basic + 1 : 0;
        while (index < inputLength) {
            int oldi = i;
            int w = 1;
            int k = 36;
            while (true) {
                int t;
                int digit;
                if (index >= inputLength) {
                    PunycodeFunctions.error("invalid-input");
                }
                if ((digit = PunycodeFunctions.basicToDigit(input.charAt(index++))) >= 36 || digit > (Integer.MAX_VALUE - i) / w) {
                    PunycodeFunctions.error("overflow");
                }
                i += digit * w;
                int n3 = k <= bias ? 1 : (t = k >= bias + 26 ? 26 : k - bias);
                if (digit < t) break;
                int baseMinusT = 36 - t;
                if (w > Integer.MAX_VALUE / baseMinusT) {
                    PunycodeFunctions.error("overflow");
                }
                w *= baseMinusT;
                k += 36;
            }
            int out = output.length() + 1;
            bias = PunycodeFunctions.adapt(i - oldi, out, oldi == 0);
            if (i / out > Integer.MAX_VALUE - n) {
                PunycodeFunctions.error("overflow");
            }
            n += i / out;
            i %= out;
            output.insert(i++, Character.toChars(n));
        }
        return output.toString();
    }

    public static String encode(String input) {
        int basicLength;
        StringBuilder output = new StringBuilder();
        int inputLength = input.length();
        int n = 128;
        int delta = 0;
        int bias = 72;
        input.codePoints().forEachOrdered(currentValue -> {
            if (currentValue < 128) {
                output.append((char)currentValue);
            }
        });
        int handledCPCount = basicLength = output.length();
        if (output.length() > 0) {
            output.append('-');
        }
        while (handledCPCount < inputLength) {
            int m = Integer.MAX_VALUE;
            for (int x = 0; x < inputLength; ++x) {
                int currentValue2 = input.charAt(x);
                if (currentValue2 < n || currentValue2 >= m) continue;
                m = currentValue2;
            }
            int handledCPCountPlusOne = handledCPCount + 1;
            if (m - n > (Integer.MAX_VALUE - delta) / handledCPCountPlusOne) {
                PunycodeFunctions.error("overflow");
            }
            delta += (m - n) * handledCPCountPlusOne;
            n = m;
            for (int x = 0; x < inputLength; ++x) {
                char currentValue3 = input.charAt(x);
                if (currentValue3 < n) {
                    ++delta;
                }
                if (currentValue3 != n) continue;
                int q = delta;
                int k = 36;
                while (true) {
                    int t;
                    int n2 = k <= bias ? 1 : (t = k >= bias + 26 ? 26 : k - bias);
                    if (q < t) break;
                    int qMinusT = q - t;
                    int baseMinusT = 36 - t;
                    output.append(Character.toChars(PunycodeFunctions.digitToBasic(t + qMinusT % baseMinusT)));
                    q = qMinusT / baseMinusT;
                    k += 36;
                }
                output.append(Character.toChars(PunycodeFunctions.digitToBasic(q)));
                bias = PunycodeFunctions.adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                delta = 0;
                ++handledCPCount;
            }
            ++delta;
            ++n;
        }
        return output.toString();
    }
}

