/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.scripts;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import us.codecraft.webmagic.scripts.languages.Language;

public class ScriptEnginePool {
    private final AtomicInteger availableCount;
    private final LinkedBlockingQueue<ScriptEngine> scriptEngines = new LinkedBlockingQueue();

    public ScriptEnginePool(Language language, int size) {
        this.availableCount = new AtomicInteger(size);
        for (int i = 0; i < size; ++i) {
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName(language.getEngineName());
            this.scriptEngines.add(engine);
        }
    }

    public ScriptEngine getEngine() {
        this.availableCount.decrementAndGet();
        return this.scriptEngines.poll();
    }

    public void release(ScriptEngine scriptEngine) {
        this.scriptEngines.add(scriptEngine);
        this.availableCount.incrementAndGet();
    }
}

