/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Page;
import video.api.client.api.models.Player;
import video.api.client.api.models.PlayerCreationPayload;
import video.api.client.api.models.PlayerUpdatePayload;
import video.api.client.api.models.PlayersListResponse;

public class PlayersApi {
    private ApiClient localVarApiClient;

    public PlayersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call deleteCall(String playerId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/players/{playerId}".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String playerId, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling delete");
        }
        Call localVarCall = this.deleteCall(playerId, _callback);
        return localVarCall;
    }

    public void delete(String playerId) throws ApiException {
        this.deleteWithHttpInfo(playerId);
    }

    public ApiResponse<Void> deleteWithHttpInfo(String playerId) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(playerId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteLogoCall(String playerId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/players/{playerId}/logo".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteLogoValidateBeforeCall(String playerId, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling deleteLogo");
        }
        Call localVarCall = this.deleteLogoCall(playerId, _callback);
        return localVarCall;
    }

    public Object deleteLogo(String playerId) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteLogoWithHttpInfo(playerId);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteLogoWithHttpInfo(String playerId) throws ApiException {
        Call localVarCall = this.deleteLogoValidateBeforeCall(playerId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/players";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listValidateBeforeCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(sortBy, sortOrder, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<PlayersListResponse> listWithHttpInfo(String sortBy, String sortOrder, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(sortBy, sortOrder, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<PlayersListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public APIlistRequest list() {
        return new APIlistRequest();
    }

    private Call getCall(String playerId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/players/{playerId}".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getValidateBeforeCall(String playerId, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling get");
        }
        Call localVarCall = this.getCall(playerId, _callback);
        return localVarCall;
    }

    public Player get(String playerId) throws ApiException {
        ApiResponse<Player> localVarResp = this.getWithHttpInfo(playerId);
        return localVarResp.getData();
    }

    public ApiResponse<Player> getWithHttpInfo(String playerId) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(playerId, null);
        Type localVarReturnType = new TypeToken<Player>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateCall(String playerId, PlayerUpdatePayload playerUpdatePayload, ApiCallback _callback) throws ApiException {
        PlayerUpdatePayload localVarPostBody = playerUpdatePayload;
        String localVarPath = "/players/{playerId}".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateValidateBeforeCall(String playerId, PlayerUpdatePayload playerUpdatePayload, ApiCallback _callback) throws ApiException {
        if (playerUpdatePayload == null) {
            throw new ApiException("Missing the required parameter 'playerUpdatePayload' when calling update");
        }
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling update");
        }
        if (playerUpdatePayload == null) {
            throw new ApiException("Missing the required parameter 'playerUpdatePayload' when calling update");
        }
        if (playerUpdatePayload == null) {
            throw new ApiException("Missing the required parameter 'playerUpdatePayload' when calling update");
        }
        Call localVarCall = this.updateCall(playerId, playerUpdatePayload, _callback);
        return localVarCall;
    }

    public Player update(String playerId, PlayerUpdatePayload playerUpdatePayload) throws ApiException {
        ApiResponse<Player> localVarResp = this.updateWithHttpInfo(playerId, playerUpdatePayload);
        return localVarResp.getData();
    }

    public ApiResponse<Player> updateWithHttpInfo(String playerId, PlayerUpdatePayload playerUpdatePayload) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(playerId, playerUpdatePayload, null);
        Type localVarReturnType = new TypeToken<Player>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createCall(PlayerCreationPayload playerCreationPayload, ApiCallback _callback) throws ApiException {
        PlayerCreationPayload localVarPostBody = playerCreationPayload;
        String localVarPath = "/players";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(PlayerCreationPayload playerCreationPayload, ApiCallback _callback) throws ApiException {
        if (playerCreationPayload == null) {
            throw new ApiException("Missing the required parameter 'playerCreationPayload' when calling create");
        }
        if (playerCreationPayload == null) {
            throw new ApiException("Missing the required parameter 'playerCreationPayload' when calling create");
        }
        Call localVarCall = this.createCall(playerCreationPayload, _callback);
        return localVarCall;
    }

    public Player create(PlayerCreationPayload playerCreationPayload) throws ApiException {
        ApiResponse<Player> localVarResp = this.createWithHttpInfo(playerCreationPayload);
        return localVarResp.getData();
    }

    public ApiResponse<Player> createWithHttpInfo(PlayerCreationPayload playerCreationPayload) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(playerCreationPayload, null);
        Type localVarReturnType = new TypeToken<Player>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadLogoCall(String playerId, File file, String link, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/players/{playerId}/logo".replaceAll("\\{playerId\\}", this.localVarApiClient.escapeString(playerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (link != null) {
            localVarFormParams.put("link", link);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadLogoValidateBeforeCall(String playerId, File file, String link, ApiCallback _callback) throws ApiException {
        if (playerId == null) {
            throw new ApiException("Missing the required parameter 'playerId' when calling uploadLogo");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadLogo");
        }
        if (link == null) {
            throw new ApiException("Missing the required parameter 'link' when calling uploadLogo");
        }
        Call localVarCall = this.uploadLogoCall(playerId, file, link, _callback);
        return localVarCall;
    }

    public Player uploadLogo(String playerId, File file, String link) throws ApiException {
        ApiResponse<Player> localVarResp = this.uploadLogoWithHttpInfo(playerId, file, link);
        return localVarResp.getData();
    }

    public ApiResponse<Player> uploadLogoWithHttpInfo(String playerId, File file, String link) throws ApiException {
        Call localVarCall = this.uploadLogoValidateBeforeCall(playerId, file, link, null);
        Type localVarReturnType = new TypeToken<Player>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public class APIlistRequest {
        private String sortBy;
        private String sortOrder;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest() {
        }

        public APIlistRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PlayersApi.this.listCall(this.sortBy, this.sortOrder, this.currentPage, this.pageSize, _callback);
        }

        public Page<Player> execute() throws ApiException {
            ApiResponse localVarResp = PlayersApi.this.listWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
            return new Page<Player>(((PlayersListResponse)localVarResp.getData()).getData(), ((PlayersListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest();
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<PlayersListResponse> executeWithHttpInfo() throws ApiException {
            return PlayersApi.this.listWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
        }
    }
}

