/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Page;
import video.api.client.api.models.TokenCreatePayload;
import video.api.client.api.models.TokenListResponse;
import video.api.client.api.models.UploadToken;
import video.api.client.api.models.Video;
import video.api.client.api.upload.UploadChunkRequestBody;
import video.api.client.api.upload.UploadProgressListener;

public class VideosDelegatedUploadApi {
    private ApiClient localVarApiClient;

    public VideosDelegatedUploadApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call deleteTokenCall(String uploadToken, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/upload-tokens/{uploadToken}".replaceAll("\\{uploadToken\\}", this.localVarApiClient.escapeString(uploadToken.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTokenValidateBeforeCall(String uploadToken, ApiCallback _callback) throws ApiException {
        if (uploadToken == null) {
            throw new ApiException("Missing the required parameter 'uploadToken' when calling deleteToken");
        }
        Call localVarCall = this.deleteTokenCall(uploadToken, _callback);
        return localVarCall;
    }

    public void deleteToken(String uploadToken) throws ApiException {
        this.deleteTokenWithHttpInfo(uploadToken);
    }

    public ApiResponse<Void> deleteTokenWithHttpInfo(String uploadToken) throws ApiException {
        Call localVarCall = this.deleteTokenValidateBeforeCall(uploadToken, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call listTokensCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/upload-tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTokensValidateBeforeCall(String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listTokensCall(sortBy, sortOrder, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<TokenListResponse> listTokensWithHttpInfo(String sortBy, String sortOrder, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listTokensValidateBeforeCall(sortBy, sortOrder, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<TokenListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public APIlistTokensRequest listTokens() {
        return new APIlistTokensRequest();
    }

    private Call getTokenCall(String uploadToken, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/upload-tokens/{uploadToken}".replaceAll("\\{uploadToken\\}", this.localVarApiClient.escapeString(uploadToken.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTokenValidateBeforeCall(String uploadToken, ApiCallback _callback) throws ApiException {
        if (uploadToken == null) {
            throw new ApiException("Missing the required parameter 'uploadToken' when calling getToken");
        }
        Call localVarCall = this.getTokenCall(uploadToken, _callback);
        return localVarCall;
    }

    public UploadToken getToken(String uploadToken) throws ApiException {
        ApiResponse<UploadToken> localVarResp = this.getTokenWithHttpInfo(uploadToken);
        return localVarResp.getData();
    }

    public ApiResponse<UploadToken> getTokenWithHttpInfo(String uploadToken) throws ApiException {
        Call localVarCall = this.getTokenValidateBeforeCall(uploadToken, null);
        Type localVarReturnType = new TypeToken<UploadToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadCall(String token, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadChunkCall(String token, File file, String videoId, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, chunksCount, chunkNum, totalBytes, chunkStart, chunkEnd + 1L, progressListener));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        localVarHeaderParams.put("Content-Range", "bytes " + chunkStart + "-" + chunkEnd + "/" + totalBytes);
        if (videoId != null) {
            localVarFormParams.put("videoId", videoId);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadValidateBeforeCall(String token, File file, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling upload");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        Call localVarCall = this.uploadCall(token, file, _callback);
        return localVarCall;
    }

    private Call uploadChunkValidateBeforeCall(String token, File file, String videoId, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling upload(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload(Async)");
        }
        Call localVarCall = this.uploadChunkCall(token, file, videoId, chunkStart, chunkEnd, totalBytes, chunksCount, chunkNum, progressListener, _callback);
        return localVarCall;
    }

    public Video upload(String token, File file) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithHttpInfo(token, file);
        return localVarResp.getData();
    }

    public Video upload(String token, File file, UploadProgressListener uploadProgressListener) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithHttpInfo(token, file, uploadProgressListener);
        return localVarResp.getData();
    }

    public ApiResponse<Video> uploadWithHttpInfo(String token, File file) throws ApiException {
        return this.uploadWithHttpInfo(token, file, null);
    }

    public ApiResponse<Video> uploadWithHttpInfo(String token, File file, final UploadProgressListener uploadProgressListener) throws ApiException {
        long chunkSize;
        String videoId = null;
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        final long totalBytes = file.length();
        if (totalBytes > (chunkSize = this.getApiClient().getUploadChunkSize())) {
            int chunkNum = 0;
            ApiResponse lastRes = null;
            for (long i = 0L; i < totalBytes; i += chunkSize) {
                Call localVarCall = this.uploadChunkValidateBeforeCall(token, file, videoId, i, Math.min(i + chunkSize, totalBytes) - 1L, totalBytes, (int)Math.ceil((float)totalBytes / (float)chunkSize), chunkNum + 1, uploadProgressListener, null);
                Type localVarReturnType = new TypeToken<Video>(){}.getType();
                lastRes = this.localVarApiClient.execute(localVarCall, localVarReturnType);
                if (videoId == null) {
                    videoId = ((Video)lastRes.getData()).getVideoId();
                }
                ++chunkNum;
            }
            return lastRes;
        }
        ApiCallback apiCallback = new ApiCallback(){

            public void onFailure(ApiException e, int statusCode, Map responseHeaders) {
            }

            public void onSuccess(Object result, int statusCode, Map responseHeaders) {
            }

            @Override
            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                if (uploadProgressListener != null) {
                    uploadProgressListener.onProgress(bytesWritten - (contentLength - totalBytes), totalBytes, 1, 1);
                }
            }

            @Override
            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
            }
        };
        Call localVarCall = this.uploadValidateBeforeCall(token, file, apiCallback);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createTokenCall(TokenCreatePayload tokenCreatePayload, ApiCallback _callback) throws ApiException {
        TokenCreatePayload localVarPostBody = tokenCreatePayload;
        String localVarPath = "/upload-tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTokenValidateBeforeCall(TokenCreatePayload tokenCreatePayload, ApiCallback _callback) throws ApiException {
        if (tokenCreatePayload == null) {
            throw new ApiException("Missing the required parameter 'tokenCreatePayload' when calling createToken");
        }
        Call localVarCall = this.createTokenCall(tokenCreatePayload, _callback);
        return localVarCall;
    }

    public UploadToken createToken(TokenCreatePayload tokenCreatePayload) throws ApiException {
        ApiResponse<UploadToken> localVarResp = this.createTokenWithHttpInfo(tokenCreatePayload);
        return localVarResp.getData();
    }

    public ApiResponse<UploadToken> createTokenWithHttpInfo(TokenCreatePayload tokenCreatePayload) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(tokenCreatePayload, null);
        Type localVarReturnType = new TypeToken<UploadToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public class APIlistTokensRequest {
        private String sortBy;
        private String sortOrder;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistTokensRequest() {
        }

        public APIlistTokensRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistTokensRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIlistTokensRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistTokensRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VideosDelegatedUploadApi.this.listTokensCall(this.sortBy, this.sortOrder, this.currentPage, this.pageSize, _callback);
        }

        public Page<UploadToken> execute() throws ApiException {
            ApiResponse localVarResp = VideosDelegatedUploadApi.this.listTokensWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
            return new Page<UploadToken>(((TokenListResponse)localVarResp.getData()).getData(), ((TokenListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistTokensRequest copy() {
            APIlistTokensRequest copy = new APIlistTokensRequest();
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<TokenListResponse> executeWithHttpInfo() throws ApiException {
            return VideosDelegatedUploadApi.this.listTokensWithHttpInfo(this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
        }
    }
}

