/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.ChaptersApi;
import video.api.client.api.models.Chapter;
import video.api.client.api.models.Page;
import video.api.client.api.models.PaginationLink;

@DisplayName(value="ChaptersApi")
public class ChaptersApiTest
extends AbstractApiTest {
    private final ChaptersApi api;

    public ChaptersApiTest() {
        this.api = this.apiClientMock.chapters();
    }

    @Nested
    @DisplayName(value="upload")
    class upload {
        private static final String PAYLOADS_PATH = "/payloads/chapters/upload/";

        upload() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            ChaptersApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.upload(null, "en", new File(""))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling upload");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.upload("12", null, new File(""))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'language' when calling upload");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.upload("12", "en", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'file' when calling upload");
            Assertions.assertThatNoException().isThrownBy(() -> ChaptersApiTest.this.api.upload("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en", new File("")));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(200, ChaptersApiTest.this.readResourceFile("/payloads/chapters/upload/responses/200.json"));
            Chapter res = ChaptersApiTest.this.api.upload("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en", new File(""));
            Assertions.assertThat((String)res.getUri()).isEqualTo("/videos/vi3N6cDinStg3oBbN79GklWS/chapters/fr");
            Assertions.assertThat((String)res.getSrc()).isEqualTo("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/chapters/fr.vtt");
            Assertions.assertThat((String)res.getLanguage()).isEqualTo("fr");
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(400, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.upload("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.upload("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="get")
    class get {
        private static final String PAYLOADS_PATH = "/payloads/chapters/get/";

        get() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            ChaptersApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.get(null, "en")).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling get");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.get("12", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'language' when calling get");
            Assertions.assertThatNoException().isThrownBy(() -> ChaptersApiTest.this.api.get("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(200, ChaptersApiTest.this.readResourceFile("/payloads/chapters/get/responses/200.json"));
            Chapter res = ChaptersApiTest.this.api.get("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en");
            Assertions.assertThat((String)res.getUri()).isEqualTo("/videos/vi3N6cDinStg3oBbN79GklWS/chapters/fr");
            Assertions.assertThat((String)res.getSrc()).isEqualTo("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/chapters/fr.vtt");
            Assertions.assertThat((String)res.getLanguage()).isEqualTo("fr");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.get("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/chapters/list/";

        list() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            ChaptersApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.list(null).execute()).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling list");
            Assertions.assertThatNoException().isThrownBy(() -> ChaptersApiTest.this.api.list("vi4k0jvEUuaTdRAEjQ4Jfrgz").execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(200, ChaptersApiTest.this.readResourceFile("/payloads/chapters/list/responses/200.json"));
            Page res = ChaptersApiTest.this.api.list("vi4k0jvEUuaTdRAEjQ4Jfrgz").execute();
            Assertions.assertThat((Integer)res.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)res.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getCurrentPageItems()).isEqualTo(2);
            Assertions.assertThat((List)res.getLinks()).containsExactlyInAnyOrder((Object[])new PaginationLink[]{new PaginationLink().rel("self").uri(URI.create("/videos/vi3N6cDinStg3oBbN79GklWS/chapters?currentPage=1&pageSize=25")), new PaginationLink().rel("first").uri(URI.create("/videos/vi3N6cDinStg3oBbN79GklWS/chapters?currentPage=1&pageSize=25")), new PaginationLink().rel("last").uri(URI.create("/videos/vi3N6cDinStg3oBbN79GklWS/chapters?currentPage=1&pageSize=25"))});
            Assertions.assertThat((List)res.getItems()).hasSize(2);
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new Chapter[]{new Chapter().src("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/chapters/en.vtt").uri("/videos/vi3N6cDinStg3oBbN79GklWS/chapters/en").language("en"), new Chapter().src("https://cdn.api.video/vod/vi3N6cDinStg3oBbN79GklWS/chapters/fr.vtt").uri("/videos/vi3N6cDinStg3oBbN79GklWS/chapters/fr").language("fr")});
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.list("vi4k0jvEUuaTdRAEjQ4Jfrgz").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }

    @Nested
    @DisplayName(value="delete")
    class delete {
        private static final String PAYLOADS_PATH = "/payloads/chapters/delete/";

        delete() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            ChaptersApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.delete(null, "en")).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling delete");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.delete("12", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'language' when calling delete");
            Assertions.assertThatNoException().isThrownBy(() -> ChaptersApiTest.this.api.delete("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en"));
        }

        @Test
        @DisplayName(value="204 response")
        public void responseWithStatus204Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(204, "");
            ChaptersApiTest.this.api.delete("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            ChaptersApiTest.this.answerOnAnyRequest(404, "");
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ChaptersApiTest.this.api.delete("vi4k0jvEUuaTdRAEjQ4Jfrgz", "en")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("");
        }
    }
}

