/*
 * Decompiled with CFR 0.152.
 */
package video.api.integration;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import video.api.client.ApiVideoClient;
import video.api.client.api.ApiException;
import video.api.client.api.models.Metadata;
import video.api.client.api.models.Page;
import video.api.client.api.models.Video;
import video.api.client.api.models.VideoCreationPayload;
import video.api.client.api.models.VideoSession;

@DisplayName(value="Integration tests of api.videos() methods")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@EnabledIfEnvironmentVariable(named="INTEGRATION_TESTS_API_TOKEN", matches=".+")
public class RawStatisticsTest {
    ApiVideoClient apiClient = new ApiVideoClient(System.getenv().get("INTEGRATION_TESTS_API_TOKEN"), ApiVideoClient.Environment.SANDBOX);

    @Nested
    @DisplayName(value="list video sessions")
    @TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class UploadByChunk {
        private Video testVideo;

        UploadByChunk() {
        }

        @BeforeAll
        public void createVideo() throws ApiException {
            this.testVideo = RawStatisticsTest.this.apiClient.videos().create(new VideoCreationPayload().title("[Java-SDK-tests] list video sessions").metadata(Collections.singletonList(new Metadata("user", "__user__"))));
        }

        @Test
        @Order(value=1)
        public void uploadVideo() throws ApiException {
            File mp4File = new File(this.getClass().getResource("/assets/sample.mp4").getFile());
            RawStatisticsTest.this.apiClient.videos().upload(this.testVideo.getVideoId(), mp4File);
        }

        @Test
        @Order(value=2)
        public void logSession() throws IOException {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.000Z'");
            df.setTimeZone(tz);
            String nowAsISO = df.format(new Date());
            String json = "{\"emitted_at\": \"" + nowAsISO + "\",\n                   \"session\": {\"loaded_at\": \"" + nowAsISO + "\", \"referrer\": \"\",\n                               \"metadata\": [{\"user\": \"python_test\"}], \"video_id\": \"" + this.testVideo.getVideoId() + "\"},\n                   \"events\": [{\"type\": \"ready\", \"emitted_at\": \"" + nowAsISO + "\", \"at\": 0}]}";
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
            Request request = new Request.Builder().url("https://collector.api.video/vod?t=1623232157262").post(body).build();
            OkHttpClient client = new OkHttpClient.Builder().build();
            Call call = client.newCall(request);
            Response response = call.execute();
        }

        @Test
        @Order(value=3)
        public void retrieveSessionWithMetadata() throws ApiException, InterruptedException {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("user", "python_test");
            Thread.sleep(5000L);
            Page sessions = RawStatisticsTest.this.apiClient.rawStatistics().listVideoSessions(this.testVideo.getVideoId()).metadata(metadata).execute();
            Assertions.assertThat((List)sessions.getItems()).hasSize(1);
            Assertions.assertThat((List)((VideoSession)sessions.getItems().get(0)).getSession().getMetadata()).hasSize(1);
            Assertions.assertThat((String)((Metadata)((VideoSession)sessions.getItems().get(0)).getSession().getMetadata().get(0)).getKey()).isEqualTo("user");
            Assertions.assertThat((String)((Metadata)((VideoSession)sessions.getItems().get(0)).getSession().getMetadata().get(0)).getValue()).isEqualTo("python_test");
        }

        @AfterAll
        public void deleteVideo() throws ApiException {
            RawStatisticsTest.this.apiClient.videos().delete(this.testVideo.getVideoId());
        }
    }
}

