/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebhooksCreationPayload
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_EVENTS = "events";
    @SerializedName(value="events")
    private List<String> events = new ArrayList<String>();
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public WebhooksCreationPayload events(List<String> events) {
        this.events = events;
        return this;
    }

    public WebhooksCreationPayload addEventsItem(String eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(example="video.encoding.quality.completed", required=true, value="A list of the webhooks that you are subscribing to. Currently \"video.encoding.quality.completed\" is the only option. video.encoding.quality.completed - a video encoding quality is ready for the video (for example the 720p quality hls encoding video is ready.)")
    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public WebhooksCreationPayload url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="https://example.com/webhooks", required=true, value="The the url to which HTTP notifications are sent. It could be any http or https URL.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhooksCreationPayload webhooksCreationPayload = (WebhooksCreationPayload)o;
        return Objects.equals(this.events, webhooksCreationPayload.events) && Objects.equals(this.url, webhooksCreationPayload.url);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhooksCreationPayload {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

