/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public class LiveStreamSessionSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_SESSION_ID = "sessionId";
    @SerializedName(value="sessionId")
    private String sessionId;
    public static final String SERIALIZED_NAME_LOADED_AT = "loadedAt";
    @SerializedName(value="loadedAt")
    private OffsetDateTime loadedAt;
    public static final String SERIALIZED_NAME_ENDED_AT = "endedAt";
    @SerializedName(value="endedAt")
    private OffsetDateTime endedAt;

    public LiveStreamSessionSession sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier for your session. You can use this to track what happens during a specific session.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public LiveStreamSessionSession loadedAt(OffsetDateTime loadedAt) {
        this.loadedAt = loadedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the session started, with the date and time presented in ISO-8601 format.")
    public OffsetDateTime getLoadedAt() {
        return this.loadedAt;
    }

    public void setLoadedAt(OffsetDateTime loadedAt) {
        this.loadedAt = loadedAt;
    }

    public LiveStreamSessionSession endedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the session ended, with the date and time presented in ISO-8601 format.")
    public OffsetDateTime getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(OffsetDateTime endedAt) {
        this.endedAt = endedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveStreamSessionSession liveStreamSessionSession = (LiveStreamSessionSession)o;
        return Objects.equals(this.sessionId, liveStreamSessionSession.sessionId) && Objects.equals(this.loadedAt, liveStreamSessionSession.loadedAt) && Objects.equals(this.endedAt, liveStreamSessionSession.endedAt);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.loadedAt, this.endedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiveStreamSessionSession {\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    loadedAt: ").append(this.toIndentedString(this.loadedAt)).append("\n");
        sb.append("    endedAt: ").append(this.toIndentedString(this.endedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

