/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.Metadata;
import video.api.client.api.models.VideoAssets;
import video.api.client.api.models.VideoSource;

public class Video
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_VIDEO_ID = "videoId";
    @SerializedName(value="videoId")
    private String videoId;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PUBLISHED_AT = "publishedAt";
    @SerializedName(value="publishedAt")
    private String publishedAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private List<Metadata> metadata = null;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private VideoSource source;
    public static final String SERIALIZED_NAME_ASSETS = "assets";
    @SerializedName(value="assets")
    private VideoAssets assets;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private String playerId;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public;
    public static final String SERIALIZED_NAME_PANORAMIC = "panoramic";
    @SerializedName(value="panoramic")
    private Boolean panoramic;
    public static final String SERIALIZED_NAME_MP4_SUPPORT = "mp4Support";
    @SerializedName(value="mp4Support")
    private Boolean mp4Support;

    public Video videoId(String videoId) {
        this.videoId = videoId;
        return this;
    }

    @ApiModelProperty(example="vi4k0jvEUuaTdRAEjQ4Prklg", required=true, value="The unique identifier of the video object.")
    public String getVideoId() {
        return this.videoId;
    }

    public void setVideoId(String videoId) {
        this.videoId = videoId;
    }

    public Video createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When a video was created, presented in ISO-8601 format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Video title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Maths video", value="The title of the video content. ")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Video description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="An amazing video explaining string theory.", value="A description for the video content. ")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Video publishedAt(String publishedAt) {
        this.publishedAt = publishedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-12-16T08:25:51+00:00", value="The date and time the API created the video. Date and time are provided using ISO-8601 UTC format.")
    public String getPublishedAt() {
        return this.publishedAt;
    }

    public void setPublishedAt(String publishedAt) {
        this.publishedAt = publishedAt;
    }

    public Video updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-12-16T08:25:51+00:10", value="The date and time the video was updated. Date and time are provided using ISO-8601 UTC format.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Video tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Video addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\"tags\": [\"maths\", \"string theory\", \"video\"]", value="One array of tags (each tag is a string) in order to categorize a video. Tags may include spaces.  ")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Video metadata(List<Metadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Video addMetadataItem(Metadata metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<Metadata>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"key\":\"Author\", \"value\":\"John Doe\"}, {\"key\":\"Format\", \"value\":\"Tutorial\"}]", value="Metadata you can use to categorise and filter videos. Metadata is a list of dictionaries, where each dictionary represents a key value pair for categorising a video. [Dynamic Metadata](https://api.video/blog/endpoints/dynamic-metadata) allows you to define a key that allows any value pair. ")
    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Metadata> metadata) {
        this.metadata = metadata;
    }

    public Video source(VideoSource source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoSource getSource() {
        return this.source;
    }

    public void setSource(VideoSource source) {
        this.source = source;
    }

    public Video assets(VideoAssets assets) {
        this.assets = assets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAssets getAssets() {
        return this.assets;
    }

    public void setAssets(VideoAssets assets) {
        this.assets = assets;
    }

    public Video playerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pl45KFKdlddgk654dspkze", value="The id of the player that will be applied on the video. ")
    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public Video _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Defines if the content is publicly reachable or if a unique token is needed for each play session. Default is true. Tutorials on [private videos](https://api.video/blog/endpoints/private-videos). ")
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public Video panoramic(Boolean panoramic) {
        this.panoramic = panoramic;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Defines if video is panoramic. ")
    public Boolean getPanoramic() {
        return this.panoramic;
    }

    public void setPanoramic(Boolean panoramic) {
        this.panoramic = panoramic;
    }

    public Video mp4Support(Boolean mp4Support) {
        this.mp4Support = mp4Support;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="This lets you know whether mp4 is supported. If enabled, an mp4 URL will be provided in the response for the video. ")
    public Boolean getMp4Support() {
        return this.mp4Support;
    }

    public void setMp4Support(Boolean mp4Support) {
        this.mp4Support = mp4Support;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Video video = (Video)o;
        return Objects.equals(this.videoId, video.videoId) && Objects.equals(this.createdAt, video.createdAt) && Objects.equals(this.title, video.title) && Objects.equals(this.description, video.description) && Objects.equals(this.publishedAt, video.publishedAt) && Objects.equals(this.updatedAt, video.updatedAt) && Objects.equals(this.tags, video.tags) && Objects.equals(this.metadata, video.metadata) && Objects.equals(this.source, video.source) && Objects.equals(this.assets, video.assets) && Objects.equals(this.playerId, video.playerId) && Objects.equals(this._public, video._public) && Objects.equals(this.panoramic, video.panoramic) && Objects.equals(this.mp4Support, video.mp4Support);
    }

    public int hashCode() {
        return Objects.hash(this.videoId, this.createdAt, this.title, this.description, this.publishedAt, this.updatedAt, this.tags, this.metadata, this.source, this.assets, this.playerId, this._public, this.panoramic, this.mp4Support);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Video {\n");
        sb.append("    videoId: ").append(this.toIndentedString(this.videoId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    publishedAt: ").append(this.toIndentedString(this.publishedAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    panoramic: ").append(this.toIndentedString(this.panoramic)).append("\n");
        sb.append("    mp4Support: ").append(this.toIndentedString(this.mp4Support)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

