/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="What kind of browser the viewer is using for the video session.")
public class VideoSessionClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public VideoSessionClient name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Firefox", value="The name of the browser used to view the video session.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VideoSessionClient version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="67.0", value="The version of the browser used to view the video session.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public VideoSessionClient type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="browser", value="The type of client used to view the video session.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSessionClient videoSessionClient = (VideoSessionClient)o;
        return Objects.equals(this.name, videoSessionClient.name) && Objects.equals(this.version, videoSessionClient.version) && Objects.equals(this.type, videoSessionClient.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSessionClient {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

