/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Environment;
import video.api.client.api.models.Page;
import video.api.client.api.models.SummariesListResponse;
import video.api.client.api.models.Summary;
import video.api.client.api.models.SummaryCreationPayload;
import video.api.client.api.models.SummarySource;
import video.api.client.api.models.SummaryUpdatePayload;

public class SummariesApi {
    private ApiClient localVarApiClient;

    public SummariesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public SummariesApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public SummariesApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public SummariesApi(Environment environment) {
        this.localVarApiClient = new ApiClient(environment.basePath);
    }

    public SummariesApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public SummariesApi(String apiKey, Environment environment) {
        this.localVarApiClient = new ApiClient(apiKey, environment.basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call createCall(SummaryCreationPayload summaryCreationPayload, ApiCallback _callback) throws ApiException {
        SummaryCreationPayload localVarPostBody = summaryCreationPayload;
        String localVarPath = "/summaries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call createValidateBeforeCall(SummaryCreationPayload summaryCreationPayload, ApiCallback _callback) throws ApiException {
        if (summaryCreationPayload == null) {
            throw new ApiException("Missing the required parameter 'summaryCreationPayload' when calling create");
        }
        if (summaryCreationPayload.getVideoId() == null) {
            throw new ApiException("Missing the required parameter 'summaryCreationPayload.videoId' when calling create");
        }
        Call localVarCall = this.createCall(summaryCreationPayload, _callback);
        return localVarCall;
    }

    public Summary create(SummaryCreationPayload summaryCreationPayload) throws ApiException {
        ApiResponse<Summary> localVarResp = this.createWithHttpInfo(summaryCreationPayload);
        return localVarResp.getData();
    }

    public ApiResponse<Summary> createWithHttpInfo(SummaryCreationPayload summaryCreationPayload) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(summaryCreationPayload, null);
        Type localVarReturnType = new TypeToken<Summary>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAsync(SummaryCreationPayload summaryCreationPayload, ApiCallback<Summary> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(summaryCreationPayload, _callback);
        Type localVarReturnType = new TypeToken<Summary>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call updateCall(String summaryId, SummaryUpdatePayload summaryUpdatePayload, ApiCallback _callback) throws ApiException {
        SummaryUpdatePayload localVarPostBody = summaryUpdatePayload;
        String localVarPath = "/summaries/{summaryId}/source".replaceAll("\\{summaryId\\}", this.localVarApiClient.escapeString(summaryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call updateValidateBeforeCall(String summaryId, SummaryUpdatePayload summaryUpdatePayload, ApiCallback _callback) throws ApiException {
        if (summaryId == null) {
            throw new ApiException("Missing the required parameter 'summaryId' when calling update");
        }
        if (summaryUpdatePayload == null) {
            throw new ApiException("Missing the required parameter 'summaryUpdatePayload' when calling update");
        }
        Call localVarCall = this.updateCall(summaryId, summaryUpdatePayload, _callback);
        return localVarCall;
    }

    public SummarySource update(String summaryId, SummaryUpdatePayload summaryUpdatePayload) throws ApiException {
        ApiResponse<SummarySource> localVarResp = this.updateWithHttpInfo(summaryId, summaryUpdatePayload);
        return localVarResp.getData();
    }

    public ApiResponse<SummarySource> updateWithHttpInfo(String summaryId, SummaryUpdatePayload summaryUpdatePayload) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(summaryId, summaryUpdatePayload, null);
        Type localVarReturnType = new TypeToken<SummarySource>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAsync(String summaryId, SummaryUpdatePayload summaryUpdatePayload, ApiCallback<SummarySource> _callback) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(summaryId, summaryUpdatePayload, _callback);
        Type localVarReturnType = new TypeToken<SummarySource>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call deleteCall(String summaryId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/summaries/{summaryId}".replaceAll("\\{summaryId\\}", this.localVarApiClient.escapeString(summaryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call deleteValidateBeforeCall(String summaryId, ApiCallback _callback) throws ApiException {
        if (summaryId == null) {
            throw new ApiException("Missing the required parameter 'summaryId' when calling delete");
        }
        Call localVarCall = this.deleteCall(summaryId, _callback);
        return localVarCall;
    }

    public void delete(String summaryId) throws ApiException {
        this.deleteWithHttpInfo(summaryId);
    }

    public ApiResponse<Void> deleteWithHttpInfo(String summaryId) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(summaryId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAsync(String summaryId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(summaryId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listCall(String videoId, String origin, String sourceStatus, String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/summaries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (videoId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("videoId", videoId));
        }
        if (origin != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("origin", origin));
        }
        if (sourceStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sourceStatus", sourceStatus));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call listValidateBeforeCall(String videoId, String origin, String sourceStatus, String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(videoId, origin, sourceStatus, sortBy, sortOrder, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<SummariesListResponse> listWithHttpInfo(String videoId, String origin, String sourceStatus, String sortBy, String sortOrder, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(videoId, origin, sourceStatus, sortBy, sortOrder, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<SummariesListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAsync(String videoId, String origin, String sourceStatus, String sortBy, String sortOrder, Integer currentPage, Integer pageSize, ApiCallback<SummariesListResponse> _callback) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(videoId, origin, sourceStatus, sortBy, sortOrder, currentPage, pageSize, _callback);
        Type localVarReturnType = new TypeToken<SummariesListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRequest list() {
        return new APIlistRequest();
    }

    private Call getSummarySourceCall(String summaryId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/summaries/{summaryId}/source".replaceAll("\\{summaryId\\}", this.localVarApiClient.escapeString(summaryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call getSummarySourceValidateBeforeCall(String summaryId, ApiCallback _callback) throws ApiException {
        if (summaryId == null) {
            throw new ApiException("Missing the required parameter 'summaryId' when calling getSummarySource");
        }
        Call localVarCall = this.getSummarySourceCall(summaryId, _callback);
        return localVarCall;
    }

    public SummarySource getSummarySource(String summaryId) throws ApiException {
        ApiResponse<SummarySource> localVarResp = this.getSummarySourceWithHttpInfo(summaryId);
        return localVarResp.getData();
    }

    public ApiResponse<SummarySource> getSummarySourceWithHttpInfo(String summaryId) throws ApiException {
        Call localVarCall = this.getSummarySourceValidateBeforeCall(summaryId, null);
        Type localVarReturnType = new TypeToken<SummarySource>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSummarySourceAsync(String summaryId, ApiCallback<SummarySource> _callback) throws ApiException {
        Call localVarCall = this.getSummarySourceValidateBeforeCall(summaryId, _callback);
        Type localVarReturnType = new TypeToken<SummarySource>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistRequest {
        private String videoId;
        private String origin;
        private String sourceStatus;
        private String sortBy;
        private String sortOrder;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest() {
        }

        public APIlistRequest videoId(String videoId) {
            this.videoId = videoId;
            return this;
        }

        public APIlistRequest origin(String origin) {
            this.origin = origin;
            return this;
        }

        public APIlistRequest sourceStatus(String sourceStatus) {
            this.sourceStatus = sourceStatus;
            return this;
        }

        public APIlistRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public APIlistRequest sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SummariesApi.this.listCall(this.videoId, this.origin, this.sourceStatus, this.sortBy, this.sortOrder, this.currentPage, this.pageSize, _callback);
        }

        public Page<Summary> execute() throws ApiException {
            ApiResponse localVarResp = SummariesApi.this.listWithHttpInfo(this.videoId, this.origin, this.sourceStatus, this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
            return new Page<Summary>(((SummariesListResponse)localVarResp.getData()).getData(), ((SummariesListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest();
            copy.videoId(this.videoId);
            copy.origin(this.origin);
            copy.sourceStatus(this.sourceStatus);
            copy.sortBy(this.sortBy);
            copy.sortOrder(this.sortOrder);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<SummariesListResponse> executeWithHttpInfo() throws ApiException {
            return SummariesApi.this.listWithHttpInfo(this.videoId, this.origin, this.sourceStatus, this.sortBy, this.sortOrder, this.currentPage, this.pageSize);
        }

        public Call executeAsync(final ApiCallback<Page<Summary>> _callback) throws ApiException {
            ApiCallback<SummariesListResponse> apiCallback = new ApiCallback<SummariesListResponse>(){

                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onFailure(e, statusCode, responseHeaders);
                }

                @Override
                public void onSuccess(SummariesListResponse result, int statusCode, Map<String, List<String>> responseHeaders) {
                    _callback.onSuccess(new Page<Summary>(result.getData(), result.getPagination(), () -> {
                        try {
                            return APIlistRequest.this.copy().currentPage((APIlistRequest.this.currentPage == null ? 1 : APIlistRequest.this.currentPage) + 1).execute();
                        }
                        catch (ApiException e) {
                            throw new RuntimeException(e);
                        }
                    }), statusCode, responseHeaders);
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    _callback.onUploadProgress(bytesWritten, contentLength, done);
                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    _callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            return SummariesApi.this.listAsync(this.videoId, this.origin, this.sourceStatus, this.sortBy, this.sortOrder, this.currentPage, this.pageSize, apiCallback);
        }
    }
}

