/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.DeepObject;

public class FilterBy
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_MEDIA_ID = "mediaId";
    @SerializedName(value="mediaId")
    private List<String> mediaId = null;
    public static final String SERIALIZED_NAME_MEDIA_TYPE = "mediaType";
    @SerializedName(value="mediaType")
    private MediaTypeEnum mediaType;
    public static final String SERIALIZED_NAME_CONTINENT = "continent";
    @SerializedName(value="continent")
    private List<ContinentEnum> continent = null;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private List<String> country = null;
    public static final String SERIALIZED_NAME_DEVICE_TYPE = "deviceType";
    @SerializedName(value="deviceType")
    private List<String> deviceType = null;
    public static final String SERIALIZED_NAME_OPERATING_SYSTEM = "operatingSystem";
    @SerializedName(value="operatingSystem")
    private List<String> operatingSystem = null;
    public static final String SERIALIZED_NAME_BROWSER = "browser";
    @SerializedName(value="browser")
    private List<String> browser = null;
    public static final String SERIALIZED_NAME_TAG = "tag";
    @SerializedName(value="tag")
    private String tag;

    public FilterBy mediaId(List<String> mediaId) {
        this.mediaId = mediaId;
        return this;
    }

    public FilterBy addMediaIdItem(String mediaIdItem) {
        if (this.mediaId == null) {
            this.mediaId = new ArrayList<String>();
        }
        this.mediaId.add(mediaIdItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"vi4blUQJFrYWbaG44NChkH27\"]", value="Returns analytics based on the unique identifiers of a video or a live stream.")
    public List<String> getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(List<String> mediaId) {
        this.mediaId = mediaId;
    }

    public FilterBy mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="video", value="")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public FilterBy continent(List<ContinentEnum> continent) {
        this.continent = continent;
        return this;
    }

    public FilterBy addContinentItem(ContinentEnum continentItem) {
        if (this.continent == null) {
            this.continent = new ArrayList<ContinentEnum>();
        }
        this.continent.add(continentItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"EU\"]", value="Returns analytics based on the viewers' continent. The list of supported continents names are based on the [GeoNames public database](https://www.geonames.org/countries/). You must use the ISO-3166 alpha2 format, for example `EU`.")
    public List<ContinentEnum> getContinent() {
        return this.continent;
    }

    public void setContinent(List<ContinentEnum> continent) {
        this.continent = continent;
    }

    public FilterBy country(List<String> country) {
        this.country = country;
        return this;
    }

    public FilterBy addCountryItem(String countryItem) {
        if (this.country == null) {
            this.country = new ArrayList<String>();
        }
        this.country.add(countryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"FR\"]", value="Returns analytics based on the viewers' country. The list of supported country names are based on the [GeoNames public database](https://www.geonames.org/countries/). You must use the ISO-3166 alpha2 format, for example `FR`.")
    public List<String> getCountry() {
        return this.country;
    }

    public void setCountry(List<String> country) {
        this.country = country;
    }

    public FilterBy deviceType(List<String> deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public FilterBy addDeviceTypeItem(String deviceTypeItem) {
        if (this.deviceType == null) {
            this.deviceType = new ArrayList<String>();
        }
        this.deviceType.add(deviceTypeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"computer\"]", value="Returns analytics based on the type of device used by the viewers. Response values can include: `computer`, `phone`, `tablet`, `tv`, `console`, `wearable`, `unknown`.")
    public List<String> getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(List<String> deviceType) {
        this.deviceType = deviceType;
    }

    public FilterBy operatingSystem(List<String> operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public FilterBy addOperatingSystemItem(String operatingSystemItem) {
        if (this.operatingSystem == null) {
            this.operatingSystem = new ArrayList<String>();
        }
        this.operatingSystem.add(operatingSystemItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"windows\"]", value="Returns analytics based on the operating system used by the viewers. Response values can include `windows`, `mac osx`, `android`, `ios`, `linux`.")
    public List<String> getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(List<String> operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public FilterBy browser(List<String> browser) {
        this.browser = browser;
        return this;
    }

    public FilterBy addBrowserItem(String browserItem) {
        if (this.browser == null) {
            this.browser = new ArrayList<String>();
        }
        this.browser.add(browserItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"firefox\"]", value="Returns analytics based on the browser used by the viewers. Response values can include `chrome`, `firefox`, `edge`, `opera`.")
    public List<String> getBrowser() {
        return this.browser;
    }

    public void setBrowser(List<String> browser) {
        this.browser = browser;
    }

    public FilterBy tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Cool videos", value="Returns analytics for videos using this tag. This filter only accepts a single value and is case sensitive. Read more about tagging your videos [here](https://docs.api.video/vod/tags-metadata).")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterBy filterBy = (FilterBy)o;
        return Objects.equals(this.mediaId, filterBy.mediaId) && Objects.equals((Object)this.mediaType, (Object)filterBy.mediaType) && Objects.equals(this.continent, filterBy.continent) && Objects.equals(this.country, filterBy.country) && Objects.equals(this.deviceType, filterBy.deviceType) && Objects.equals(this.operatingSystem, filterBy.operatingSystem) && Objects.equals(this.browser, filterBy.browser) && Objects.equals(this.tag, filterBy.tag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mediaId, this.mediaType, this.continent, this.country, this.deviceType, this.operatingSystem, this.browser, this.tag});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterBy {\n");
        sb.append("    mediaId: ").append(this.toIndentedString(this.mediaId)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    continent: ").append(this.toIndentedString(this.continent)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    deviceType: ").append(this.toIndentedString(this.deviceType)).append("\n");
        sb.append("    operatingSystem: ").append(this.toIndentedString(this.operatingSystem)).append("\n");
        sb.append("    browser: ").append(this.toIndentedString(this.browser)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContinentEnum {
        AS("AS"),
        AF("AF"),
        NA("NA"),
        SA("SA"),
        AN("AN"),
        EU("EU"),
        AZ("AZ");

        private String value;

        private ContinentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContinentEnum fromValue(String value) {
            for (ContinentEnum b : ContinentEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ContinentEnum> {
            public void write(JsonWriter jsonWriter, ContinentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContinentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContinentEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MediaTypeEnum {
        VIDEO("video"),
        LIVE_STREAM("live-stream");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MediaTypeEnum fromValue(String value) {
            for (MediaTypeEnum b : MediaTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MediaTypeEnum> {
            public void write(JsonWriter jsonWriter, MediaTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MediaTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MediaTypeEnum.fromValue(value);
            }
        }
    }
}

