/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.DeepObject;
import video.api.client.api.models.PaginationLink;

public class Pagination
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ITEMS_TOTAL = "itemsTotal";
    @SerializedName(value="itemsTotal")
    private Integer itemsTotal;
    public static final String SERIALIZED_NAME_PAGES_TOTAL = "pagesTotal";
    @SerializedName(value="pagesTotal")
    private Integer pagesTotal;
    public static final String SERIALIZED_NAME_PAGE_SIZE = "pageSize";
    @SerializedName(value="pageSize")
    private Integer pageSize;
    public static final String SERIALIZED_NAME_CURRENT_PAGE = "currentPage";
    @SerializedName(value="currentPage")
    private Integer currentPage;
    public static final String SERIALIZED_NAME_CURRENT_PAGE_ITEMS = "currentPageItems";
    @SerializedName(value="currentPageItems")
    private Integer currentPageItems;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private List<PaginationLink> links = new ArrayList<PaginationLink>();

    @Nullable
    @ApiModelProperty(value="Total number of items that exist.")
    public Integer getItemsTotal() {
        return this.itemsTotal;
    }

    @Nullable
    @ApiModelProperty(value="Number of items listed in the current page.")
    public Integer getPagesTotal() {
        return this.pagesTotal;
    }

    @Nullable
    @ApiModelProperty(value="Maximum number of item per page.")
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Nullable
    @ApiModelProperty(value="The current page index.")
    public Integer getCurrentPage() {
        return this.currentPage;
    }

    @Nullable
    @ApiModelProperty(value="The number of items on the current page.")
    public Integer getCurrentPageItems() {
        return this.currentPageItems;
    }

    public Pagination links(List<PaginationLink> links) {
        this.links = links;
        return this;
    }

    public Pagination addLinksItem(PaginationLink linksItem) {
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<PaginationLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<PaginationLink> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination pagination = (Pagination)o;
        return Objects.equals(this.itemsTotal, pagination.itemsTotal) && Objects.equals(this.pagesTotal, pagination.pagesTotal) && Objects.equals(this.pageSize, pagination.pageSize) && Objects.equals(this.currentPage, pagination.currentPage) && Objects.equals(this.currentPageItems, pagination.currentPageItems) && Objects.equals(this.links, pagination.links);
    }

    public int hashCode() {
        return Objects.hash(this.itemsTotal, this.pagesTotal, this.pageSize, this.currentPage, this.currentPageItems, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pagination {\n");
        sb.append("    itemsTotal: ").append(this.toIndentedString(this.itemsTotal)).append("\n");
        sb.append("    pagesTotal: ").append(this.toIndentedString(this.pagesTotal)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    currentPage: ").append(this.toIndentedString(this.currentPage)).append("\n");
        sb.append("    currentPageItems: ").append(this.toIndentedString(this.currentPageItems)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

