/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.AnalyticsApi;
import video.api.client.api.models.AnalyticsAggregatedMetricsResponse;
import video.api.client.api.models.Page;

@DisplayName(value="AnalyticsApi")
public class AnalyticsApiTest
extends AbstractApiTest {
    private final AnalyticsApi api;

    public AnalyticsApiTest() {
        this.api = this.apiClientMock.analytics();
    }

    @Nested
    @DisplayName(value="getMetricsOverTime")
    class getMetricsOverTime {
        private static final String PAYLOADS_PATH = "/payloads/analytics/getMetricsOverTime/";

        getMetricsOverTime() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            AnalyticsApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> AnalyticsApiTest.this.api.getMetricsOverTime("play").execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getMetricsOverTime/responses/200.json"));
            Page res = AnalyticsApiTest.this.api.getMetricsOverTime("play").execute();
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(400, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getMetricsOverTime/responses/400-0.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getMetricsOverTime("play").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("An attribute is invalid.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(404, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getMetricsOverTime/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getMetricsOverTime("play").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("Unrecognized request URL.");
        }

        @Test
        @DisplayName(value="429 response")
        public void responseWithStatus429Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(429, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getMetricsOverTime/responses/429.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getMetricsOverTime("play").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(429))).hasMessage("Too many requests.");
        }
    }

    @Nested
    @DisplayName(value="getMetricsBreakdown")
    class getMetricsBreakdown {
        private static final String PAYLOADS_PATH = "/payloads/analytics/getMetricsBreakdown/";

        getMetricsBreakdown() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            AnalyticsApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> AnalyticsApiTest.this.api.getMetricsBreakdown("play", "media-id").execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getMetricsBreakdown/responses/200.json"));
            Page res = AnalyticsApiTest.this.api.getMetricsBreakdown("play", "media-id").execute();
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(400, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getMetricsBreakdown/responses/400-0.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getMetricsBreakdown("play", "media-id").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("An attribute is invalid.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(404, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getMetricsBreakdown/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getMetricsBreakdown("play", "media-id").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("Unrecognized request URL.");
        }

        @Test
        @DisplayName(value="429 response")
        public void responseWithStatus429Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(429, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getMetricsBreakdown/responses/429.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getMetricsBreakdown("play", "media-id").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(429))).hasMessage("Too many requests.");
        }
    }

    @Nested
    @DisplayName(value="getAggregatedMetrics")
    class getAggregatedMetrics {
        private static final String PAYLOADS_PATH = "/payloads/analytics/getAggregatedMetrics/";

        getAggregatedMetrics() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            AnalyticsApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> AnalyticsApiTest.this.api.getAggregatedMetrics("play", "count").execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(200, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getAggregatedMetrics/responses/200.json"));
            AnalyticsAggregatedMetricsResponse res = AnalyticsApiTest.this.api.getAggregatedMetrics("play", "count").execute();
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(400, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getAggregatedMetrics/responses/400-0.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getAggregatedMetrics("play", "count").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("An attribute is invalid.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(404, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getAggregatedMetrics/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getAggregatedMetrics("play", "count").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("Unrecognized request URL.");
        }

        @Test
        @DisplayName(value="429 response")
        public void responseWithStatus429Test() throws ApiException {
            AnalyticsApiTest.this.answerOnAnyRequest(429, AnalyticsApiTest.this.readResourceFile("/payloads/analytics/getAggregatedMetrics/responses/429.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AnalyticsApiTest.this.api.getAggregatedMetrics("play", "count").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(429))).hasMessage("Too many requests.");
        }
    }
}

