/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.SummariesApi;
import video.api.client.api.models.Page;
import video.api.client.api.models.SummaryCreationPayload;
import video.api.client.api.models.SummaryUpdatePayload;

@DisplayName(value="SummariesApi")
public class SummariesApiTest
extends AbstractApiTest {
    private final SummariesApi api;

    public SummariesApiTest() {
        this.api = this.apiClientMock.summaries();
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/summaries/list/";

        list() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            SummariesApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> SummariesApiTest.this.api.list());
            Assertions.assertThatNoException().isThrownBy(() -> SummariesApiTest.this.api.list());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            SummariesApiTest.this.answerOnAnyRequest(200, SummariesApiTest.this.readResourceFile("/payloads/summaries/list/responses/200.json"));
            Page execute = SummariesApiTest.this.api.list().execute();
        }
    }

    @Nested
    @DisplayName(value="delete")
    class delete {
        private static final String PAYLOADS_PATH = "/payloads/summaries/delete/";

        delete() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            SummariesApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> SummariesApiTest.this.api.delete("summary_1CGHWuXjhxmeH4WiZ51234"));
            Assertions.assertThatThrownBy(() -> SummariesApiTest.this.api.delete(null)).hasMessage("Missing the required parameter 'summaryId' when calling delete");
        }
    }

    @Nested
    @DisplayName(value="update")
    class update {
        private static final String PAYLOADS_PATH = "/payloads/summaries/update/";

        update() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            SummariesApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> SummariesApiTest.this.api.update("summary_1CGHWuXjhxmeH4WiZ51234", new SummaryUpdatePayload()));
            Assertions.assertThatThrownBy(() -> SummariesApiTest.this.api.update(null, null)).hasMessage("Missing the required parameter 'summaryId' when calling update");
        }

        @Test
        @DisplayName(value="409 response")
        public void responseWithStatus409Test() throws ApiException {
            SummariesApiTest.this.answerOnAnyRequest(409, SummariesApiTest.this.readResourceFile("/payloads/summaries/update/responses/409.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SummariesApiTest.this.api.update("summary_1CGHWuXjhxmeH4WiZ51234", new SummaryUpdatePayload())).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(409))).hasMessage("A summary already exists or is being created on this video.");
        }
    }

    @Nested
    @DisplayName(value="get")
    class get {
        private static final String PAYLOADS_PATH = "/payloads/summaries/getSummarySource/";

        get() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            SummariesApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatNoException().isThrownBy(() -> SummariesApiTest.this.api.getSummarySource("summary_1CGHWuXjhxmeH4WiZ51234"));
            Assertions.assertThatThrownBy(() -> SummariesApiTest.this.api.getSummarySource(null)).hasMessage("Missing the required parameter 'summaryId' when calling getSummarySource");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            SummariesApiTest.this.answerOnAnyRequest(404, SummariesApiTest.this.readResourceFile("/payloads/summaries/getSummarySource/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SummariesApiTest.this.api.getSummarySource("summary_1CGHWuXjhxmeH4WiZ51234")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="create")
    class create {
        private static final String PAYLOADS_PATH = "/payloads/summaries/create/";

        create() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            SummariesApiTest.this.answerOnAnyRequest(201, "{}");
            Assertions.assertThatThrownBy(() -> SummariesApiTest.this.api.create(new SummaryCreationPayload())).hasMessage("Missing the required parameter 'summaryCreationPayload.videoId' when calling create");
            Assertions.assertThatThrownBy(() -> SummariesApiTest.this.api.create(null)).hasMessage("Missing the required parameter 'summaryCreationPayload' when calling create");
            Assertions.assertThatNoException().isThrownBy(() -> SummariesApiTest.this.api.create(new SummaryCreationPayload().videoId("123")));
        }

        @Test
        @DisplayName(value="409 response")
        public void responseWithStatus409Test() throws ApiException {
            SummariesApiTest.this.answerOnAnyRequest(409, SummariesApiTest.this.readResourceFile("/payloads/summaries/create/responses/409.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SummariesApiTest.this.api.create(new SummaryCreationPayload().videoId("123"))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(409))).hasMessage("A summary already exists or is being created on this video.");
        }
    }
}

