/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRpcException;
import wf.bitcoin.javabitcoindrpcclient.BitcoinUtil;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class BitcoinRawTxBuilder {
    public final BitcoindRpcClient bitcoin;
    public Set<BitcoindRpcClient.TxInput> inputs = new LinkedHashSet<BitcoindRpcClient.TxInput>();
    public List<BitcoindRpcClient.TxOutput> outputs = new ArrayList<BitcoindRpcClient.TxOutput>();
    private HashMap<String, BitcoindRpcClient.RawTransaction> txCache = new HashMap();

    public BitcoinRawTxBuilder(BitcoindRpcClient bitcoin) {
        this.bitcoin = bitcoin;
    }

    public BitcoinRawTxBuilder in(BitcoindRpcClient.TxInput in) {
        this.inputs.add(new Input(in.txid(), in.vout()));
        return this;
    }

    public BitcoinRawTxBuilder in(String txid, int vout) {
        this.in(new BitcoindRpcClient.BasicTxInput(txid, vout));
        return this;
    }

    public BitcoinRawTxBuilder out(String address, double amount) {
        if (amount <= 0.0) {
            return this;
        }
        this.outputs.add(new BitcoindRpcClient.BasicTxOutput(address, amount));
        return this;
    }

    public BitcoinRawTxBuilder in(double value) throws BitcoinRpcException {
        return this.in(value, 6);
    }

    public BitcoinRawTxBuilder in(double value, int minConf) throws BitcoinRpcException {
        List<BitcoindRpcClient.Unspent> unspent = this.bitcoin.listUnspent(minConf);
        double v = value;
        for (BitcoindRpcClient.Unspent o : unspent) {
            if (!this.inputs.contains(new Input(o))) {
                this.in(o);
                v = BitcoinUtil.normalizeAmount(v - o.amount());
            }
            if (!(v < 0.0)) continue;
            break;
        }
        if (v > 0.0) {
            throw new BitcoinRpcException("Not enough bitcoins (" + v + "/" + value + ")");
        }
        return this;
    }

    private BitcoindRpcClient.RawTransaction tx(String txId) throws BitcoinRpcException {
        BitcoindRpcClient.RawTransaction tx = this.txCache.get(txId);
        if (tx != null) {
            return tx;
        }
        tx = this.bitcoin.getRawTransaction(txId);
        this.txCache.put(txId, tx);
        return tx;
    }

    public BitcoinRawTxBuilder outChange(String address) throws BitcoinRpcException {
        return this.outChange(address, 0.0);
    }

    public BitcoinRawTxBuilder outChange(String address, double fee) throws BitcoinRpcException {
        double is = 0.0;
        for (BitcoindRpcClient.TxInput i : this.inputs) {
            is = BitcoinUtil.normalizeAmount(is + this.tx(i.txid()).vOut().get(i.vout()).value());
        }
        double os = fee;
        for (BitcoindRpcClient.TxOutput o : this.outputs) {
            os = BitcoinUtil.normalizeAmount(os + o.amount());
        }
        if (os < is) {
            this.out(address, BitcoinUtil.normalizeAmount(is - os));
        }
        return this;
    }

    public String create() throws BitcoinRpcException {
        return this.bitcoin.createRawTransaction(new ArrayList<BitcoindRpcClient.TxInput>(this.inputs), this.outputs);
    }

    public String sign() throws BitcoinRpcException {
        return this.bitcoin.signRawTransaction(this.create(), null, null);
    }

    public String send() throws BitcoinRpcException {
        return this.bitcoin.sendRawTransaction(this.sign());
    }

    private class Input
    extends BitcoindRpcClient.BasicTxInput {
        public Input(String txid, int vout) {
            super(txid, vout);
        }

        public Input(BitcoindRpcClient.TxInput copy) {
            this(copy.txid(), copy.vout());
        }

        public int hashCode() {
            return this.txid.hashCode() + this.vout;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BitcoindRpcClient.TxInput)) {
                return false;
            }
            BitcoindRpcClient.TxInput other = (BitcoindRpcClient.TxInput)obj;
            return this.vout == other.vout() && this.txid.equals(other.txid());
        }
    }
}

