/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.krotjson;

import java.util.Date;
import java.util.Map;
import wf.bitcoin.krotjson.CrippledJavaScriptParser;

public class JSON {
    public static String stringify(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number || o instanceof Boolean) {
            return String.valueOf(o);
        }
        if (o instanceof Date) {
            return "new Date(" + ((Date)o).getTime() + ")";
        }
        if (o instanceof Map) {
            return JSON.stringify((Map)o);
        }
        if (o instanceof Iterable) {
            return JSON.stringify((Iterable)o);
        }
        if (o instanceof Object[]) {
            return JSON.stringify((Object[])o);
        }
        return JSON.stringify(String.valueOf(o));
    }

    public static String stringify(Map m) {
        StringBuilder b = new StringBuilder();
        b.append('{');
        boolean first = true;
        for (Map.Entry e : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(JSON.stringify(e.getKey().toString()));
            b.append(':');
            b.append(JSON.stringify(e.getValue()));
        }
        b.append('}');
        return b.toString();
    }

    public static String stringify(Iterable c) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        boolean first = true;
        for (Object o : c) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(JSON.stringify(o));
        }
        b.append(']');
        return b.toString();
    }

    public static String stringify(Object[] c) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        boolean first = true;
        for (Object o : c) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(JSON.stringify(o));
        }
        b.append(']');
        return b.toString();
    }

    public static String stringify(String s) {
        StringBuilder b = new StringBuilder(s.length() + 2);
        b.append('\"');
        while (!s.isEmpty()) {
            char c = s.charAt(0);
            switch (c) {
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\"': 
                case '\\': {
                    b.append("\\");
                    b.append(c);
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            s = s.substring(1);
        }
        b.append('\"');
        return b.toString();
    }

    public static Object parse(String s) {
        return CrippledJavaScriptParser.parseJSExpr(s);
    }
}

