package org.codehaus.xfire.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.dom.DOMHandler;
import org.codehaus.xfire.handler.dom.Message;
import org.codehaus.xfire.java.message.MessageBridge;
import org.codehaus.xfire.java.message.MessageBridgeFactory;


/**
 * Handles java services.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 18, 2004
 */
public class JavaServiceHandler
    extends AbstractLogEnabled
    implements DOMHandler
{

	public static final String NAME = "java";

	/**
	 * @see org.codehaus.xfire.handler.Handler#invoke(org.codehaus.xfire.MessageContext)
	 */
	public void invoke( MessageContext context,
                        Message request,
                        Message response )
		throws XFireFault
	{
		JavaService service = (JavaService) context.getService();

		MessageBridge pipe = MessageBridgeFactory.createMessageReader( service,
                                                                       context,
                                                                       request,
                                                                       response );

        try
        {
            Operation operation = pipe.getOperation();
            
            // Read in the parameters...
            List params = pipe.read();
            
            // invoke the service method...
            Object value = invokeService( operation, params, service );

            pipe.write( value );
        }
        catch (XFireRuntimeException e)
        {
            getLogger().warn("Error invoking service.", e);
            throw new XFireFault("Error invoking service.", e, XFireFault.SENDER);
        }
	}

    /**
     * @param methodName
     * @param params
     */
    private Object invokeService( Operation operation, List params, JavaService service ) throws XFireFault
    {
        Method method = operation.getMethod();
        
        try
        {
            Object serviceObject = getServiceObject( service );

            return method.invoke( serviceObject, params.toArray() );
        }
        catch (IllegalArgumentException e)
        {
            throw new XFireFault( "Illegal argument.", e, XFireFault.SENDER );
        }
        catch (InvocationTargetException e)
        {
            Throwable t = e.getTargetException();
            t.getMessage();
            
            if ( t instanceof XFireFault )
            {
                throw (XFireFault) t;
            }
            else if ( t instanceof Exception )
            {
                getLogger().warn("Error invoking service.", t);
                throw new XFireFault( (Exception) t, XFireFault.SENDER );
            }
            else
            {
                getLogger().warn("Error invoking service.", e);
                throw new XFireRuntimeException( "Error invoking service.", e );
            }
        }
        catch (IllegalAccessException e)
        {
            throw new XFireFault( "Couldn't access service object.", e, XFireFault.RECEIVER );
        }
    }

    /**
     * @return
     */
    private Object getServiceObject(JavaService sd)
        throws XFireFault
    {
        try
        {
            return sd.getServiceClass().newInstance();
        }
        catch (InstantiationException e)
        {
            throw new XFireFault( "Couldn't instantiate service object.", e, XFireFault.RECEIVER );
        }
        catch (IllegalAccessException e)
        {
            throw new XFireFault( "Couldn't access service object.", e, XFireFault.RECEIVER );
        }
    }

    /**
     * @see org.codehaus.xfire.handler.dom.DOMHandler#getUnderstoodHeaders()
     */
    public QName[] getUnderstoodHeaders()
    {
        return null;
    }
}
