package org.codehaus.xfire.java;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Set;

/**
 * An operation that be performed on a service.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 20, 2004
 */
public class Operation
{
    private Hashtable types;
    
    private Hashtable params;
    
    private Method method;
    
    private Class outClass;
    
    private String outName;
    
    public Operation( Method method, JavaService service )
    {
        params = new Hashtable();
        
        this.method = method;
        
        Class[] paramClasses = method.getParameterTypes();
        
        for ( int j = 0; j < paramClasses.length; j++ )
        {
            String paramName = null;
            
            paramName = "in" + j;
            System.out.println("registering: " + paramName + " " + paramClasses[j].getName());
            addParameterClass( paramName, paramClasses[j] );
        }
        
        
        outName = "out";

        outClass = method.getReturnType();
    }

    public Class getOutParameterClass()
    {
        return outClass;
    }
    
    public String getOutParameterName()
    {
        return outName;
    }
    
    /**
     * @param string
     * @return
     */
    public Class getParameterClass( String paramName )
    {
        return (Class) params.get( paramName );
    }

    /**
     * @param paramName
     * @param class1
     */
    public void addParameterClass( String paramName, Class clazz )
    {
        params.put( paramName, clazz );
    }
    
    public Set getParameters()
    {
        return params.keySet();
    }
    
    public Method getMethod()
    {
        return method;
    }

    /**
     * @return
     */
    public String getName()
    {
        return method.getName();
    }
}
