package org.codehaus.xfire.java.mapping;

import org.dom4j.QName;

/**
 * Holds a class and QName pair for serializer mappings used internally.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 22, 2004
 */
public class ClassQNamePair
{
    private Class clazz;
    private QName qname;
    
    public ClassQNamePair( Class javaClass, QName qname )
    {
        this.clazz = javaClass ;
        this.qname = qname;
    }
    
	/**
	 * @return Returns the clazz.
	 */
	public Class getJavaClass()
	{
		return clazz;
	}
    
	/**
	 * @return Returns the qname.
	 */
	public QName getQName()
	{
		return qname;
	}

    /**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o)
    {
        if (o == null)
            return false;
        
        ClassQNamePair p = (ClassQNamePair) o;
        
        // Test straight equality
        if (p.getQName() == this.qname 
            &&
            p.getJavaClass() == this.clazz)
        {
            return true;
        }
        
        return ( p.getQName().equals(this.qname) 
                 && 
                 p.getJavaClass().equals(this.clazz));
    }
    
    public int hashCode()
    {
        int hashcode = 0;
        
        if (getJavaClass() != null)
        {
            hashcode ^= getJavaClass().hashCode();
        }
        
        if (getQName() != null)
        {
            hashcode ^= getQName().hashCode();
        }
        
        return hashcode;
    }
}
