package org.codehaus.xfire.java.mapping;

import org.codehaus.xfire.java.type.*;
import org.dom4j.QName;

/**
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 18, 2004
 */
public interface TypeMapping
{
    /**
     * Checks whether or not type mapping between specified XML
     * type and Java type is registered.
     *
     * @param javaType Class of the Java type
     * @param xmlType Qualified name of the XML data type
     * @return boolean; <code>true</code> if type mapping between the
     *      specified XML type and Java type is registered;
     *      otherwise <code>false</code>
     */
    public boolean isRegistered(Class javaType, QName xmlType);


    public void register( Class javaType,
                          QName xmlType,
                          Class typeClass );

    public Type getType(Class javaType, QName xmlType);


    public void removeType(Class javaType, QName xmlType);
    
    public Type getType( Class javaType );
    
    public Type getType( QName xmlType );

    public QName getTypeQName(Class clazz);
    
    public String getEncodingStyleURI();

    public void setEncodingStyleURI( String encodingStyleURI );
}
