package org.codehaus.xfire.java.message;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.dom.Message;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.dom4j.Element;

/**
 * MessageReader
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public abstract class AbstractMessageBridge
    implements MessageBridge
{
    private JavaService service;

    private MessageContext context;
    
    private Message request;

    private Message response;

    protected Operation operation;
    
    public AbstractMessageBridge( JavaService service, 
                                  MessageContext context,
                                  Message request,
                                  Message response )
    {
        this.service = service;
        this.context = context;
        this.request = request;
        this.response = response;
    }
    
    /**
     * @return Returns the typeMappingRegistry.
     */
    public TypeMapping getTypeMapping()
    {
        return service.getTypeMapping();
    }  
    
    /**
     * @return Returns the service.
     */
    public JavaService getService()
    {
        return service;
    }
    
    /**
     * @return Returns the context.
     */
    public MessageContext getContext()
    {
        return context;
    }
    
    /**
     * @param context The context to set.
     */
    public void setContext(MessageContext context)
    {
        this.context = context;
    }
    
    public Element getRequest()
    {
        return request.getBody();
    }

    /**
     * @return Returns the response body.
     */
    public Element getResponse()
    {
        return response.getBody();
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageBridge#getOperation()
     */
    public Operation getOperation()
    {
        return operation;
    }
    
    /**
     * @param operation The operation to set.
     */
    public void setOperation(Operation operation)
    {
        this.operation = operation;
    }

	private String namespace;

	/**
	 * @return Returns the namespace.
	 */
	public String getNamespace()
	{
	    return namespace;
	}

	/**
	 * @param namespace The namespace to set.
	 */
	public void setNamespace( String namespace )
	{
	    this.namespace = namespace;
	}
}
