package org.codehaus.xfire.java.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.dom.Message;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/**
 * Bridges Document/Literal style messages.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Apr 7, 2004
 */
public class DocumentBridge
    extends AbstractMessageBridge
{
	public DocumentBridge( JavaService service, 
            MessageContext context,
            Message request,
            Message response )
    {
		super( service, context, request, response );
        
        setNamespace( getService().getDefaultNamespace() );
        findOperation();
	}

    private void findOperation()
    {
        Namespace ns = NamespaceHelper.getNamespace( getRequest(),
                                                     getNamespace() );
        boolean found = false;
        
        for( Iterator itr = getService().getOperations().iterator(); itr.hasNext(); )
        {
            Operation op = (Operation) itr.next();
            
            if ( op.getParameters().size() == getRequest().elements().size() )
            {
                found = true;
                
                for ( Iterator pitr = op.getParameters().iterator(); pitr.hasNext(); )
                {
                    String param = (String) pitr.next();
                    
                    Element element = getRequest().element( new QName(param, ns) );
                    
                    if ( element == null )
                    {
                        found = false;
                        break;
                    }
                }
            
                if ( found )
                {
                    setOperation( op );
                    found = false;
                }
            }
        }
    }

    public List read()
    {
        List parameters = new ArrayList();
        
        for ( Iterator itr = getRequest().elementIterator(); itr.hasNext(); )
        {
            Element element = (Element) itr.next();
            
            Class clazz = getOperation().getParameterClass( element.getName() );

            // TODO: support complex type mappings...
            Type type = getTypeMapping().getType( clazz );

            parameters.add( type.readObject( new LiteralReader( element ) ) );
        }
        
        return parameters;
    }

    public void write(Object value)
    {
        Type type = getTypeMapping().getType( value.getClass() );

        Namespace ns = null;
        
        if ( type.isComplex() )
        {
            ns = type.getSchemaType().getNamespace();
        }
        else
        {
        	ns = NamespaceHelper.getNamespace( getResponse(), getNamespace() );
        }
        
        QName outQ = new QName( getOperation().getOutParameterName(), ns );
        Element out = getResponse().addElement( outQ );

        type.writeObject( value, new LiteralWriter( out ) );
    }
}
