package org.codehaus.xfire.java.message;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.codehaus.xfire.util.DateUtils;
import org.dom4j.Element;

/**
 * Reads literal encoded messages.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class LiteralReader
    implements MessageReader
{
    private Element root;
    
    public LiteralReader( Element root )
    {
        this.root = root;
    }
    
    /**
     * @see org.codehaus.xfire.java.message.MessageReader#getValue()
     */
    public String getValue()
    {
        return root.getText();
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageReader#getValueAsInt()
     */
    public int getValueAsInt()
    {
        return Integer.parseInt( getValue() );
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageReader#getValueAsDate()
     */
    public Date getValueAsDate()
    {
         return DateUtils.parseDate( getValue() );
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageReader#getValueAsDateTime()
     */
    public Date getValueAsDateTime()
    {
        return DateUtils.parseDateTime( getValue() );
    }
    
    public Element getElement()
    {
        return root;
    }

    /**
	 * @see org.codehaus.xfire.java.message.MessageReader#getValueAsCalendar()
	 */
    public Calendar getValueAsCalendar()
    {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime( DateUtils.parseDateTime(getValue()) );
        return calendar;
    }

    /**
	 * @see org.codehaus.xfire.java.message.MessageReader#getReader(java.lang.String)
	 */
    public MessageReader getReader(String name)
    {
        Element child = getElement().element( name );
        
        return new LiteralReader( child );
    }

    /**
	 * @see org.codehaus.xfire.java.message.MessageReader#getReaders()
	 */
    public List getReaders()
    {
        List readers = new ArrayList();
        
        for ( Iterator itr = getElement().elementIterator(); itr.hasNext(); )
        {
            readers.add( new LiteralReader( (Element) itr.next() ) );
        }
        
        return readers;
    }

    /**
	 * @see org.codehaus.xfire.java.message.MessageReader#getReaders(java.lang.String)
	 */
    public List getReaders(String name)
    {
        List readers = new ArrayList();
        
        for ( Iterator itr = getElement().elementIterator( name ); itr.hasNext(); )
        {
            readers.add( new LiteralReader( (Element) itr.next() ) );
        }
        
        return readers;
    }

	/**
	 * @see org.codehaus.xfire.java.message.MessageReader#getValueAsLong()
	 */
	public long getValueAsLong()
	{
		return Long.parseLong( getValue() );
	}

	/**
	 * @see org.codehaus.xfire.java.message.MessageReader#getValueAsDouble()
	 */
	public double getValueAsDouble()
	{
		return Double.parseDouble( getValue() );
	}

	/**
	 * @see org.codehaus.xfire.java.message.MessageReader#getValueAsFloat()
	 */
	public float getValueAsFloat()
	{
		return Float.parseFloat( getValue() );
	}

	/**
	 * @see org.codehaus.xfire.java.message.MessageReader#getValueAsBoolean()
	 */
	public boolean getValueAsBoolean()
	{
		return Boolean.valueOf( getValue() ).booleanValue();
	}
}
