package org.codehaus.xfire.java.message;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.codehaus.xfire.util.DateUtils;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/**
 * LiteralWriter
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class LiteralWriter
    implements MessageWriter
{
    private Element element;
    
    private Namespace namespace;

    private static Calendar calendar = Calendar.getInstance();
    
    public LiteralWriter( Element element )
    {
        this.element = element;
        this.namespace = element.getNamespace();
    }
    
    /**
     * @see org.codehaus.xfire.java.message.MessageWriter#writeValue(java.lang.Object)
     */
    public void writeValue(Object value)
    {
        if ( value != null )
            getElement().setText( value.toString() );        
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageWriter#getWriter(java.lang.String)
     */
    public MessageWriter getWriter(String name)
    {
        Element child = element.addElement( new QName( name, namespace ) );
        
        return new LiteralWriter( child );
    }

    public String getNamespace()
    {
        return namespace.getURI();
    }

    public void setNamespace(String namespace)
    {
        this.namespace = NamespaceHelper.getNamespace( getElement(), namespace );
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageWriter#writeValueAsCalendar(java.util.Calendar)
     */
    public void writeValueAsCalendar(Calendar calendar)
    {
         DateUtils.formatDateTime( calendar.getTime() );
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageWriter#writeValueAsInt(java.lang.Integer)
     */
    public void writeValueAsInt(Integer i)
    {
        writeValue( i.toString() );
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageWriter#writeValueAsDate(java.util.Date)
     */
    public void writeValueAsDateTime(Date date)
    {
         writeValue( DateUtils.formatDateTime(date) );
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageWriter#writeValueAsDate(java.util.Date)
     */
    public void writeValueAsDate(Date date)
    {
        DateUtils.formatDate( calendar.getTime() );
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageWriter#getElement()
     */
    public Element getElement()
    {
        return element;
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageWriter#getWriters()
     */
    public List getWriters()
    {
        return null;
    }

	/**
	 * @see org.codehaus.xfire.java.message.MessageWriter#writeValueAsDouble(java.lang.Double)
	 */
	public void writeValueAsDouble(Double d)
	{
		writeValue( d.toString() );
	}

	/**
	 * @see org.codehaus.xfire.java.message.MessageWriter#writeValueAsLong(java.lang.Long)
	 */
	public void writeValueAsLong(Long l)
	{
		writeValue( l.toString() );
	}

	/**
	 * @see org.codehaus.xfire.java.message.MessageWriter#writeValueAsFloat(java.lang.Float)
	 */
	public void writeValueAsFloat(Float f)
	{
		writeValue( f.toString() );
	}

	/**
	 * @see org.codehaus.xfire.java.message.MessageWriter#writeValueAsBoolean(boolean)
	 */
	public void writeValueAsBoolean(boolean b)
	{
		writeValue( Boolean.toString(b) );
	}

}
