package org.codehaus.xfire.java.message;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.dom.Message;
import org.codehaus.xfire.java.JavaService;

/**
 * Create a MessageReaders and MessageWriters for a JavaService.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Apr 7, 2004
 */
public class MessageBridgeFactory
{

	public static MessageBridge createMessageReader( JavaService service,
                                                     MessageContext context,
                                                     Message request,
                                                     Message response )
	{
        AbstractMessageBridge reader;
        
		if ( service.getStyle().equals("wrapped")
             &&
             service.getUse().equals("literal") )
        {
            reader = new WrappedBridge( service, context, request, response );
        }
        else if ( service.getStyle().equals("document")
                  &&
                  service.getUse().equals("literal") )
        {
            reader = new DocumentBridge( service, context, request, response );
        }
        else if ( service.getStyle().equals("rpc")
                  &&
                  service.getUse().equals("literal") )
        {
            reader = new RPCLiteralBridge( service, context, request, response );
        }
        else
        {
        	throw new UnsupportedOperationException( "Service style/use not supported." );
        }
        
        return reader;
	}
}
