package org.codehaus.xfire.java.message;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.dom4j.Element;

/**
 * Writes messages.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public interface MessageWriter
{
    void writeValue( Object value );

    void writeValueAsCalendar( Calendar calendar );

    void writeValueAsDate( Date date );
    
    void writeValueAsDateTime( Date date );
    
    //void writeValueAsTime( Date date );

    void writeValueAsInt( Integer i );

    void writeValueAsDouble(Double double1);

    void writeValueAsLong(Long l);

    void writeValueAsFloat(Float f);
    
    Element getElement();

    MessageWriter getWriter(String name);

    List getWriters();
    
    String getNamespace();
    
    void setNamespace( String namespace );

	/**
	 * @param b
	 */
	void writeValueAsBoolean(boolean b);
}
