package org.codehaus.xfire.java.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.dom.Message;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/**
 * Reads RPC/Literal style messages.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Apr 7, 2004
 */
public class RPCLiteralBridge
    extends AbstractMessageBridge
{
    private Element payload;

    public RPCLiteralBridge( JavaService service, 
            MessageContext context,
            Message request,
            Message response )
    {
        super( service, context, request, response );
        
        setNamespace( getPayload().getNamespaceURI() );
        String methodName = getPayload().getName();

        setOperation( getService().getOperation( methodName, getNamespace() ) );
	}
   
    /**
     * @return Returns the payload.
     */
    public Element getPayload()
    {
        if ( payload == null )
        {
            payload = (Element) getRequest().elements().get(0);
        }
        
        return payload;
    }
    
    public List read()
    {
        List parameters = new ArrayList();
        
        for ( Iterator itr = getPayload().elementIterator(); itr.hasNext(); )
        {
            Element element = (Element) itr.next();
            
            Class clazz = operation.getParameterClass( element.getName() );

            Type type = getTypeMapping().getType( clazz );

            parameters.add( type.readObject( new LiteralReader( element ) ) );
        }
        
        return parameters;
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageBridge#write(java.lang.Object)
     */
    public void write(Object value)
    {
        Namespace ns = NamespaceHelper.getNamespace( getResponse(), getNamespace() );
        
        QName responseQ = new QName( getOperation().getName() + "Response", ns );
        Element methodResponse = getResponse().addElement( responseQ );
        
        QName outQ = new QName( "out", ns );
        Element out = methodResponse.addElement( outQ );
        
        Type type = getTypeMapping().getType( value.getClass() );

        type.writeObject( value, new LiteralWriter( out ) );
    }
}
