package org.codehaus.xfire.java.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.dom.Message;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/**
 * Reads Document/Literal style messages.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Apr 7, 2004
 */
public class WrappedBridge
    extends AbstractMessageBridge
{
    
    private Element payload;

    public WrappedBridge( JavaService service, 
                          MessageContext context,
                          Message request,
                          Message response )
    {
        super( service, context, request, response );
        
        setNamespace( getPayload().getNamespaceURI() );
        String methodName = getPayload().getName();

        setOperation( getService().getOperation( methodName, getNamespace() ) );
	}
    
    /**
     * @return Returns the payload.
     */
    public Element getPayload()
    {
        if ( payload == null )
        {
            payload = (Element) getRequest().elements().get(0);
        }
        
        return payload;
    }
    
    public List read() throws XFireFault
    {
        List parameters = new ArrayList();
        
        for ( Iterator itr = getPayload().elementIterator(); itr.hasNext(); )
        {
            Element element = (Element) itr.next();
            
            Operation op = getOperation();
            
            if ( op == null )
            {
                throw new XFireFault("Invalid operation.", XFireFault.SENDER);
            }

            Class clazz = op.getParameterClass( element.getName() );
            
            if ( clazz == null )
            {
                throw new XFireFault("Invalid parameter.", XFireFault.SENDER);
            }
            
            Type type = getTypeMapping().getType( clazz );

            parameters.add( type.readObject( new LiteralReader( element ) ) );
        }
        
        return parameters;
    }

    /**
     * @see org.codehaus.xfire.java.message.MessageBridge#write(java.lang.Object)
     */
    public void write(Object value)
    {
        Namespace responseNS = NamespaceHelper.getNamespace( getResponse(), getNamespace() );
        
        QName responseQ = new QName( getOperation().getName() + "Response", responseNS );
        Element methodResponse = getResponse().addElement( responseQ );
        
        Type type = getTypeMapping().getType( value.getClass() );
        Namespace ns = null;
        
        if ( type.isComplex() )
        {
            ns = type.getSchemaType().getNamespace();
        }
        else
        {
            ns = NamespaceHelper.getNamespace( getResponse(), getNamespace() );
        }
        
        QName outQ = new QName( getOperation().getOutParameterName(), ns );
        Element out = methodResponse.addElement( outQ );

        type.writeObject( value, new LiteralWriter( out ) );
    }
}
