package org.codehaus.xfire.java.type;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.java.message.MessageReader;
import org.codehaus.xfire.java.message.MessageWriter;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/**
 * An ArrayType.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class ArrayType
    extends Type
{

	/**
     * @see org.codehaus.xfire.java.type.Type#readObject(org.dom4j.Element)
     */
    public Object readObject(MessageReader reader)
        throws XFireRuntimeException
    {
        try
        {
            Type compType = getComponentType();
            
            List readers = reader.getReaders( compType.getSchemaType().getName() );
            
            Object[] array = (Object[]) Array.newInstance( compType.getTypeClass(), readers.size() );
            
            int i = 0;
            for ( Iterator itr = readers.iterator(); itr.hasNext(); )
            {
                Type type = getTypeMapping().getType( compType.getTypeClass() );
                
                array[i] = type.readObject( (MessageReader) itr.next() );
                i++;
            }
            
            return array;
        }
        catch (IllegalArgumentException e)
        {
            throw new XFireRuntimeException("Illegal argument.", e);
        }
    }

    /**
     * @see org.codehaus.xfire.java.type.Type#writeObject(java.lang.Object)
     */
    public void writeObject(Object object, MessageWriter writer)
        throws XFireRuntimeException
    {
        try
        {
        	Object[] array = (Object[]) object;
            
            Type type = getComponentType();
            
            if ( type == null )
                throw new XFireRuntimeException( "Couldn't find type for " + type.getTypeClass() + "." );
            
            List writers = writer.getWriters();
            
            for ( int i = 0; i < array.length; i++ )
            {
                BeanInfo info = Introspector.getBeanInfo( type.getTypeClass(), Object.class );

                type.writeObject( array[i], 
                                  writer.getWriter( info.getBeanDescriptor().getDisplayName() ) );
                i++;
            }
        }
        catch (IntrospectionException e)
        {
            throw new XFireRuntimeException("Couldn't introspect.", e);
        }
        catch (IllegalArgumentException e)
        {
            throw new XFireRuntimeException("Illegal argument.", e);
        } 
    }

    /**
     * @see org.codehaus.xfire.java.type.Type#writeSchema()
     */
    public void writeSchema( Element root )
    {
        try
        {        
            Namespace xsdNs = root.getNamespaceForURI( SOAPConstants.XSD );
            org.dom4j.QName complexQ = new org.dom4j.QName("complexType", xsdNs);   

            Element complex = root.addElement( complexQ );

            complex.addAttribute( "name", getSchemaType().getName() );

            org.dom4j.QName seqQ = new org.dom4j.QName("sequence", xsdNs); 
            Element seq = complex.addElement( seqQ );

            org.dom4j.QName elementQ = new org.dom4j.QName("element", xsdNs); 
            Element element = seq.addElement( elementQ );
            
            Type componentType = getComponentType();
            Namespace ns = NamespaceHelper.getNamespace( root, componentType.getSchemaType().getNamespaceURI() );

            QName typeDom4j = DocumentFactory.getInstance().createQName( componentType.getSchemaType().getName(),
                                                                         ns );
            
            String typeName = typeDom4j.getNamespacePrefix() + ":" + componentType.getSchemaType().getName();
            
            element.addAttribute("name", componentType.getSchemaType().getName());
            element.addAttribute("type", typeName);
            // TODO: Add config support for nillable
            element.addAttribute("nillable", "true");
 
            element.addAttribute("minOccurs", "0");
            element.addAttribute("maxOccurs", "unbounded");
            
        }
        catch (IllegalArgumentException e)
        {
            throw new XFireRuntimeException("Illegal argument.", e);
        }
    }
    
    /**
     * We need to write a complex type schema for Beans, so return true.
     * 
     * @see org.codehaus.xfire.java.type.Type#isComplex()
     */
    public boolean isComplex()
    {
        return true;
    }
    
    /**
     * @see org.codehaus.xfire.java.type.Type#getDependencies()
     */
    public Set getDependencies()
    {
        Set deps = new HashSet();
        
        deps.add( getTypeMapping().getType( getTypeClass().getComponentType() ) );
        
        return deps;
    }
    
    protected Type getComponentType()
    {
        Class compType = getTypeClass().getComponentType();
        
        return getTypeMapping().getType( compType );
    }
}
