package org.codehaus.xfire.java.type;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;

import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.java.message.MessageReader;
import org.codehaus.xfire.java.message.MessageWriter;
import org.codehaus.xfire.util.NamespaceHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

/**
 * Serializes JavaBeans.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class BeanType
    extends Type
{

	/**
     * @see org.codehaus.xfire.java.type.Type#readObject(org.dom4j.Element)
     */
    public Object readObject(MessageReader reader)
        throws XFireRuntimeException
    {
        try
        {
            Class clazz = getTypeClass();
            Object object = clazz.newInstance();
            
            BeanInfo info = Introspector.getBeanInfo( clazz, Object.class );
            
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            
            for ( int i = 0; i < pd.length; i++ )
            {

                Class typeClass = pd[i].getPropertyType();
                Type type = getTypeMapping().getType( typeClass );

                if ( type == null )
                    throw new XFireRuntimeException( "Couldn't find type for " + typeClass + " for property " + pd[i].getName() );

                Object writeObj = type.readObject( reader.getReader( pd[i].getName() ) );
                
                pd[i].getWriteMethod().invoke( object , new Object[] { writeObj } );
            }
            
            return object;
        }
        catch (IntrospectionException e)
        {
            throw new XFireRuntimeException("Couldn't introspect.", e);
        }
        catch (IllegalArgumentException e)
        {
            throw new XFireRuntimeException("Illegal argument.", e);
        } 
        catch (IllegalAccessException e)
        {
            throw new XFireRuntimeException("Illegal access.", e);
        }
        catch (InvocationTargetException e)
        {
            // TODO: remember ITEs can go funny sometimes...
            throw new XFireRuntimeException("Couldn't invoke.", e);
        }
		catch (InstantiationException e)
		{
            throw new XFireRuntimeException("Couldn't instantiate.", e);
		}
    }

    /**
     * @see org.codehaus.xfire.java.type.Type#writeObject(java.lang.Object)
     */
    public void writeObject(Object object, MessageWriter writer)
        throws XFireRuntimeException
    {
        try
        {
        	// TODO: could be an exception as well.
            BeanInfo info = Introspector.getBeanInfo( getTypeClass(), Object.class );
            
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            
            for ( int i = 0; i < pd.length; i++ )
            {
                Class typeClass = pd[i].getPropertyType();
                Type type = getTypeMapping().getType( typeClass );

                if ( type == null )
                    throw new XFireRuntimeException( "Couldn't find type for " + typeClass + " for property " + pd[i].getName() );
                
                type.writeObject( pd[i].getReadMethod().invoke( object , new Object[0] ),
                                  writer.getWriter( pd[i].getName() ) );
            }
        }
        catch (IntrospectionException e)
        {
            throw new XFireRuntimeException("Couldn't introspect.", e);
        }
        catch (IllegalArgumentException e)
        {
            throw new XFireRuntimeException("Illegal argument.", e);
        } 
        catch (IllegalAccessException e)
        {
            throw new XFireRuntimeException("Illegal access.", e);
        }
        catch (InvocationTargetException e)
        {
            // TODO: remember ITEs can go funny sometimes...
            throw new XFireRuntimeException("Couldn't invoke.", e);
        }
    }

    /**
     * @see org.codehaus.xfire.java.type.Type#writeSchema()
     */
    public void writeSchema( Element root )
    {
        try
        {
            // TODO: this bean could be an exception as well.
            BeanInfo info = Introspector.getBeanInfo( getTypeClass(), Object.class );
            
            Namespace xsdNs = root.getNamespaceForURI( SOAPConstants.XSD );
            org.dom4j.QName complexQ = new org.dom4j.QName("complexType", xsdNs); 
            
            Element complex = root.addElement( complexQ );
            
            complex.addAttribute( "name", this.getSchemaType().getName() );

            org.dom4j.QName seqQ = new org.dom4j.QName("sequence", xsdNs); 
            Element seq = complex.addElement( seqQ );
            
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            
            org.dom4j.QName elementQ = new org.dom4j.QName("element", xsdNs); 
            
            for ( int i = 0; i < pd.length; i++ )
            {
                Class typeClass = pd[i].getPropertyType();
                
                Element element = seq.addElement( elementQ );
                
                Type type = getTypeMapping().getType( typeClass );
                
                Namespace typeNS = NamespaceHelper.getNamespace( root, type.getSchemaType().getNamespaceURI() );
                
                element.addAttribute( "name", pd[i].getDisplayName() );
                // TODO: Add config support for nillable
                element.addAttribute( "nillable", "true" );
                element.addAttribute("type", typeNS.getPrefix() + ":" + type.getSchemaType().getName());
            }
        }
        catch (IntrospectionException e)
        {
            throw new XFireRuntimeException("Couldn't introspect.", e);
        }
        catch (IllegalArgumentException e)
        {
            throw new XFireRuntimeException("Illegal argument.", e);
        } 
    }
    
    /**
     * We need to write a complex type schema for Beans, so return true.
     * 
     * @see org.codehaus.xfire.java.type.Type#isComplex()
     */
    public boolean isComplex()
    {
        return true;
    }
}
