package org.codehaus.xfire.java.type;

import org.codehaus.xfire.java.message.MessageReader;
import org.codehaus.xfire.java.message.MessageWriter;

/**
 * SimpleSerializer
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class BooleanType
    extends Type
{

    /**
     * @see org.codehaus.xfire.java.type.Type#readObject(org.dom4j.Element)
     */
    public Object readObject(MessageReader reader)
    {
        return new Boolean( reader.getValueAsBoolean() );
    }

    /**
     * @see org.codehaus.xfire.java.type.Type#writeObject(java.lang.Object)
     */
    public void writeObject(Object object, MessageWriter writer)
    {
        writer.writeValueAsBoolean( ((Boolean) object).booleanValue() );
    }
}
