package org.codehaus.xfire.java.type;

import java.util.Calendar;

import org.codehaus.xfire.java.message.MessageReader;
import org.codehaus.xfire.java.message.MessageWriter;

/**
 * Type for the Calendar class.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class CalendarType
    extends Type
{
    /**
     * @see org.codehaus.xfire.java.type.Type#readObject(org.dom4j.Element)
     */
    public Object readObject(MessageReader reader)
    {
        return reader.getValueAsCalendar();
    }

    /**
     * @see org.codehaus.xfire.java.type.Type#writeObject(java.lang.Object)
     */
    public void writeObject(Object object, MessageWriter writer)
    {
        writer.writeValueAsCalendar( (Calendar) object );
    }

}
