package org.codehaus.xfire.java.type;

import org.codehaus.xfire.java.message.MessageReader;
import org.codehaus.xfire.java.message.MessageWriter;
import org.dom4j.Element;

/**
 * SimpleSerializer
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class LongType
    extends Type
{

    /**
     * @see org.codehaus.xfire.java.type.Type#readObject(org.dom4j.Element)
     */
    public Object readObject(MessageReader reader)
    {
        return new Integer( reader.getValueAsInt() );
    }

    /**
     * @see org.codehaus.xfire.java.type.Type#writeObject(java.lang.Object)
     */
    public void writeObject(Object object, MessageWriter writer)
    {

        writer.writeValueAsInt( (Integer) object );
    }

    /**
     * @see org.codehaus.xfire.java.type.Type#writeSchema()
     */
    public void writeSchema( Element element )
    {
    }
}
