package org.codehaus.xfire.java.type;

import java.util.Set;

import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.message.MessageReader;
import org.codehaus.xfire.java.message.MessageWriter;
import org.codehaus.xfire.wsdl.WSDLType;
import org.dom4j.Element;
import org.dom4j.QName;

/**
 * Type
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public abstract class Type
    implements WSDLType
{
    private QName schemaType;
    private TypeMapping typeMapping;
    private Class typeClass;
    
    public Type()
    {
    }
    
    public abstract Object readObject( MessageReader reader );
    
    public abstract void writeObject( Object object, MessageWriter writer );

    public void writeSchema( Element element )
    {
    }
    
	/**
	 * @return Returns the typeMapping.
	 */
	public TypeMapping getTypeMapping()
	{
		return typeMapping;
	}
    
	/**
	 * @param typeMapping The typeMapping to set.
	 */
	public void setTypeMapping( TypeMapping typeMapping )
	{
		this.typeMapping = typeMapping;
	}
    
	/**
	 * @return Returns the typeClass.
	 */
	public Class getTypeClass()
	{
		return typeClass;
	}
    
	/**
	 * @param typeClass The typeClass to set.
	 */
	public void setTypeClass( Class typeClass )
	{
		this.typeClass = typeClass;
	}

    /**
     * @return True if a complex type schema must be written.
     */
    public boolean isComplex()
    {
        return false;
    }

    /**
     * Return a set of Type dependencies.  Returns null if this type
     * has no dependencies.
     * 
     * @return
     */
    public Set getDependencies()
    {
        // TODO Auto-generated method stub
        return null;
    }
    
    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj)
    {
        if ( obj instanceof Type )
        {
            Type type = (Type) obj;

            if ( type.getSchemaType().equals( getSchemaType() )
                 &&
                 type.getTypeClass().equals( getTypeClass() ) )
            {
                return true;
            }
        }
        
        return false;
    }
    
    public int hashCode()
    {
        int hashcode = 0;
        
        if (getTypeClass() != null)
        {
            hashcode ^= getTypeClass().hashCode();
        }
        
        if (getSchemaType() != null)
        {
            hashcode ^= getSchemaType().hashCode();
        }
        
        return hashcode;
    }
    
    /**
     * @return Returns the qName.
     */
    public QName getSchemaType()
    {
        return schemaType;
    }
    
    /**
     * @param name The qName to set.
     */
    public void setSchemaType(QName name)
    {
        schemaType = name;
    }
}
