package org.codehaus.xfire.java.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;

import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.wsdl.WSDL;


/**
 * WSDL
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public abstract class AbstractWSDL
    extends org.codehaus.xfire.wsdl.AbstractWSDL
    implements WSDL
{  
    private PortType portType;
    
    private Binding binding;
    
    private Set transports;
    
    private Map wsdlOps;

    public AbstractWSDL( JavaService service, Set transports ) throws WSDLException
    {
        super(service);
        this.transports = transports;
        wsdlOps = new HashMap();
        
        PortType portType = createAbstractInterface();
        
        createConcreteInterface(portType);

        writeDocument();
    }
    
    protected QName createJavaxQName( org.dom4j.QName qname )
    {
        return new QName( qname.getNamespaceURI(), qname.getName() );
    }
    
    public PortType createAbstractInterface()
        throws WSDLException
    {
        JavaService service = (JavaService) getService();
        Definition def = getDefinition();
        
        QName portName = new QName( service.getDefaultNamespace(),
                                    service.getName() + "PortType" );
        
        portType = def.createPortType();
        portType.setQName( portName );
        portType.setUndefined(false);
        def.addPortType( portType );
        
        // Create Abstract operations
        for ( Iterator itr = service.getOperations().iterator(); itr.hasNext(); )
        {
            Operation op = (Operation) itr.next();
            Message req = getInputMessage(op);
            def.addMessage( req );
            
            Message res = getOutputMessage(op);
            def.addMessage( res );

            javax.wsdl.Operation wsdlOp = createOperation( op.getName(), req, res );
            wsdlOp.setUndefined(false);
            portType.addOperation( wsdlOp );
            
            wsdlOps.put( op.getName(), wsdlOp );
        }
        
        return portType;
    }
    
    public void createConcreteInterface( PortType portType )
    {
        JavaService service = (JavaService) getService();
        Definition def = getDefinition();
        
        QName name = new QName( service.getDefaultNamespace(),
                service.getName() );

        // Create a concrete instance for each transport.
        Service wsdlService = def.createService();
        wsdlService.setQName( name );
        
        for ( Iterator itr = transports.iterator(); itr.hasNext(); )
        {
            Transport transport = (Transport) itr.next();
            
            Binding transportBinding = transport.createBinding( portType, service );
            
            for ( Iterator oitr = service.getOperations().iterator(); oitr.hasNext(); )
            {
                // todo: move out of the first loop, we'll be creating req/res multiple times otherwise
                Operation op = (Operation) oitr.next();
                
                javax.wsdl.Operation wsdlOp = (javax.wsdl.Operation) wsdlOps.get( op.getName() );
                
                BindingOperation bop = transport.createBindingOperation( portType, wsdlOp, service );
                transportBinding.addBindingOperation( bop );
            }

            Port transportPort = transport.createPort(transportBinding, service);
            
            def.addBinding( transportBinding );
            wsdlService.addPort( transportPort );
        }
        
        def.addService( wsdlService );

    }

    private Message getOutputMessage(Operation op)
    {
        // response message
        Message res = getDefinition().createMessage();
        res.setQName( new QName( getService().getDefaultNamespace(),
                                 op.getName() + "Response") );

        res.setUndefined(false);

        createOutputParts( res, op );
         
        return res;
    }

    private Message getInputMessage(Operation op)
    {
        Message req = getDefinition().createMessage();
        req.setQName( new QName( getService().getDefaultNamespace(), op.getName() + "Request") );
        req.setUndefined(false);
        
        createInputParts( req, op );

        return req;
    }

	protected abstract void createInputParts( Message req, Operation op );

    protected abstract void createOutputParts( Message req, Operation op );

    public javax.wsdl.Operation createOperation( String opName, Message req, Message res )
    {
        Definition def = getDefinition();
        
        Input input = def.createInput();
        input.setMessage( req );
        input.setName( req.getQName().getLocalPart() );

        Output output = def.createOutput();
        output.setMessage( res );
        output.setName( res.getQName().getLocalPart() );
        
        javax.wsdl.Operation wsdlOp = def.createOperation();
        wsdlOp.setName( opName );
        wsdlOp.setInput( input );
        wsdlOp.setOutput( output );
        
        return wsdlOp;
    }
}
