package org.codehaus.xfire.java.wsdl;

import java.util.Iterator;
import java.util.Set;

import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;

import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.type.Type;
import org.dom4j.Element;
import org.dom4j.Namespace;


/**
 * Creates Document style WSDL documents for JavaServices.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class DocumentWSDL
    extends AbstractWSDL
{    
    public DocumentWSDL( JavaService service, Set transports ) throws WSDLException
    {
        super( service, transports );
    }

    protected void createOutputParts( Message res, Operation op )
    {
        JavaService service = (JavaService) getService();
        
        String opName = op.getName() + "Response";
        
        Class clazz = op.getOutParameterClass();
        
        // response message part
        Part part = getDefinition().createPart();
        part.setName( op.getOutParameterName() );
        part.setElementName( new QName( getService().getDefaultNamespace(), 
                                        op.getOutParameterName() ) );

        Type type = service.getTypeMapping().getType( clazz );
        addDependency( type );
        
        Element schemaType = createSchemaType( service.getDefaultNamespace() );
        Element element = schemaType.addElement( elementQ );
        element.addAttribute( "name", op.getOutParameterName() );
            
        Class paramClass = op.getOutParameterClass();
        Type paramType = service.getTypeMapping().getType( paramClass );
        Namespace typeNS = getNamespace( paramType.getSchemaType().getNamespaceURI() );
        
        element.addAttribute("type", typeNS.getPrefix() + ":" + type.getSchemaType().getName() );
        
        res.addPart( part );
    }

    protected void createInputParts( Message req, Operation op )
    {
        JavaService service = (JavaService) getService();
        
        String opName = op.getName() + "Request";

        for ( Iterator itr = op.getParameters().iterator(); itr.hasNext(); )
        {
            String paramName = (String) itr.next();
            
            Part part = getDefinition().createPart();
            part.setName( paramName );
            part.setElementName( new QName( service.getDefaultNamespace(), paramName ) );
           
            Element schemaType = createSchemaType( service.getDefaultNamespace() );
            Element element = schemaType.addElement( elementQ );
            element.addAttribute( "name", paramName );
            
            Class paramClass = op.getParameterClass( paramName );
            Type paramType = service.getTypeMapping().getType( paramClass );
            Namespace typeNS = getNamespace( paramType.getSchemaType().getNamespaceURI() );
            
            element.addAttribute("type", typeNS.getPrefix() + ":" + paramType.getSchemaType().getName() );

            req.addPart( part );
        }
    }
}
