package org.codehaus.xfire.java.wsdl;

import java.util.Set;
import javax.wsdl.WSDLException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.plexus.PlexusXFireComponent;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.WSDL;
import org.codehaus.xfire.wsdl.WSDLBuilder;

/**
 * Create a WSDL document for a JavaService.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Apr 7, 2004
 */
public class JavaWSDLBuilder
	extends PlexusXFireComponent
	implements WSDLBuilder
{
	/**
	 * @param service
	 * @return
	 */
	public WSDL createWSDL( Service s )
        throws WSDLException
	{
        JavaService service = (JavaService) s;
        
	    TransportManager manager;
        try
        {
            manager = (TransportManager) getServiceLocator().lookup( TransportManager.ROLE );
        }
        catch (ComponentLookupException e)
        {
            throw new XFireRuntimeException( "Couldn't find TransportManager.", e );
        }
        
        Set transports = manager.getTransports( service.getName() );
	    
		if ( service.getStyle().equals("wrapped")
             &&
             service.getUse().equals("literal") )
        {
            return new WrappedWSDL( service, transports );
        }
        else if ( service.getStyle().equals("document")
                  &&
                  service.getUse().equals("literal") )
        {
            return new DocumentWSDL( service, transports );
        }
        else if ( service.getStyle().equals("rpc")
                &&
                service.getUse().equals("literal") )
        {
            return new RPCLiteralWSDL( service, transports );
        }
        else
        {
        	throw new UnsupportedOperationException( "Service style/use not supported." );
        }
	}
}
