package org.codehaus.xfire.java.wsdl;

import java.util.Iterator;
import java.util.Set;

import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;

import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.type.Type;


/**
 * Creates RPC/Literal style WSDL documents for a JavaService.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class RPCLiteralWSDL
    extends AbstractWSDL
{
    public RPCLiteralWSDL( JavaService service, Set transports ) throws WSDLException
    {
        super( service, transports );
    }
    
	/**
	 * @see org.codehaus.xfire.java.wsdl.AbstractWSDL#createInputParts(javax.wsdl.Message, org.codehaus.xfire.java.Operation)
	 */
	protected void createInputParts( Message req, Operation op )
	{
        // add parameters as parts
        for ( Iterator itr = op.getParameters().iterator(); itr.hasNext(); )
        {
            String param = (String) itr.next();
            Class clazz = op.getParameterClass( param );
            Type type = ((JavaService) getService()).getTypeMapping().getType( clazz );
             
            Part part = getDefinition().createPart();
            part.setName( param );
            part.setTypeName( createJavaxQName(type.getSchemaType()) );

            addDependency( type );

            req.setUndefined(false);
            req.addPart( part );
        }
	}

	/**
	 * @see org.codehaus.xfire.java.wsdl.AbstractWSDL#createOutputParts(javax.wsdl.Message, org.codehaus.xfire.java.Operation)
	 */
	protected void createOutputParts( Message req, Operation op )
	{
        Class clazz = op.getOutParameterClass();
        
        // response message part
        Part part = getDefinition().createPart();

        Type type = ((JavaService) getService()).getTypeMapping().getType( clazz );
        addDependency( type );
        
        part.setName( op.getOutParameterName() );
        part.setTypeName( createJavaxQName(type.getSchemaType()) );
        
        req.addPart( part );
	}
}
