package org.codehaus.xfire.java.wsdl;

import java.util.Iterator;
import java.util.Set;

import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;

import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.java.Operation;
import org.codehaus.xfire.java.type.Type;
import org.dom4j.Element;
import org.dom4j.Namespace;


/**
 * Creates Document style WSDL documents for JavaServices.
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class WrappedWSDL
    extends DocumentWSDL
{    

    public WrappedWSDL( JavaService service, Set transports ) throws WSDLException
    {
        super( service, transports );
    }

    private QName createResponseDocumentType(Operation op, Part part, Type type)
    {
        JavaService service = (JavaService) getService();
        
        String opName = op.getName() + "Response";
        QName responseType = new QName( service.getDefaultNamespace(), opName );

        Element schemaType = createSchemaType( service.getDefaultNamespace() );
        Element element = schemaType.addElement( elementQ );
        element.addAttribute( "name", opName );

        org.dom4j.QName complexQ = new org.dom4j.QName("complexType", xsdNs);
        Element complex = element.addElement( complexQ );

        if ( op.getOutParameterClass().isAssignableFrom( Void.class ) )
            return responseType;
        
        Element sequence = createSequence( complex );
            
        Class paramClass = op.getOutParameterClass();
        Type paramType = service.getTypeMapping().getType( paramClass );
        Namespace typeNS = getNamespace( paramType.getSchemaType().getNamespaceURI() );
        
        org.dom4j.QName outElementQ = new org.dom4j.QName("element", xsdNs);
        Element outElement = sequence.addElement( outElementQ );
        
        outElement.addAttribute("name", op.getOutParameterName());
        outElement.addAttribute("type", typeNS.getPrefix() + ":" + type.getSchemaType().getName() );

        outElement.addAttribute("minOccurs", "1");
        outElement.addAttribute("maxOccurs", "1");

        return responseType;
    }

    private QName createRequestDocumentType(Operation op, Part part)
    {
        JavaService service = (JavaService) getService();
        
        String opName = op.getName();// + "Request";

        Element schemaType = createSchemaType( service.getDefaultNamespace() );
        Element element = schemaType.addElement( elementQ );
        element.addAttribute( "name", opName );
        
        org.dom4j.QName complexQ = new org.dom4j.QName("complexType", xsdNs);
        Element complex = element.addElement( complexQ );
        
        if ( op.getParameters().size() > 0 )
        {
            Element sequence = createSequence( complex );
    
            for ( Iterator itr = op.getParameters().iterator(); itr.hasNext(); )
            {
                String paramName = (String) itr.next();
                
                Class paramClass = op.getParameterClass( paramName );
                Type type = service.getTypeMapping().getType( paramClass );
                
                addDependency(type);
                
                Namespace typeNS = getNamespace( type.getSchemaType().getNamespaceURI() );
                
                org.dom4j.QName outElementQ = new org.dom4j.QName("element", xsdNs);
                Element outElement = sequence.addElement( outElementQ );

                outElement.addAttribute("name", paramName );
                outElement.addAttribute("type", typeNS.getPrefix() + ":" + type.getSchemaType().getName() );

                outElement.addAttribute("minOccurs", "1");
                outElement.addAttribute("maxOccurs", "1");
            }
        }

        return new QName( getService().getDefaultNamespace(), opName );
    }

    private Element createSequence( Element complex )
    {
        org.dom4j.QName sequenceQ = new org.dom4j.QName("sequence", xsdNs);
        return complex.addElement( sequenceQ );
    }

	/**
	 * @see org.codehaus.xfire.java.wsdl.AbstractWSDL#createInputParts(javax.wsdl.Message, org.codehaus.xfire.java.Operation)
	 */
	protected void createInputParts( Message req, Operation op )
	{
        Part part = getDefinition().createPart();
            
        QName typeQName = createRequestDocumentType(op, part);
        
        part.setName( "parameters" );
        part.setElementName( typeQName );
        
        req.addPart( part );
	}
    
    
	/**
	 * @see org.codehaus.xfire.java.wsdl.AbstractWSDL#createOutputParts(javax.wsdl.Message, org.codehaus.xfire.java.Operation)
	 */
	protected void createOutputParts( Message req, Operation op )
	{
		Class clazz = op.getOutParameterClass();
        
        // response message part
        Part part = getDefinition().createPart();

        Type type = ((JavaService)getService()).getTypeMapping().getType( clazz );
        addDependency( type );
        
        // Document style service
        QName typeQName = createResponseDocumentType(op, part, type);
        part.setElementName( typeQName );
        part.setName( "parameters" );
        
        req.addPart( part );
	}
}
