package org.codehaus.xfire.java;

import java.util.Collection;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.java.test.Echo;
import org.codehaus.xfire.java.type.Type;
import org.codehaus.xfire.service.Service;
import org.dom4j.QName;


/**
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 21, 2004
 */
public class JavaServiceTest
    extends PlexusTestCase
{
    public void testServiceRegister() throws Exception
    {
        AbstractJavaService hello = (AbstractJavaService) lookup( Service.ROLE, "echo" );
        
        assertEquals( "Echo", hello.getName() );
        
        assertEquals( Echo.class, hello.getServiceClass() );
        
        assertNotNull( hello.getServiceHandler() );
        
        assertNotNull( hello.getFaultHandler() );
        
        assertEquals( 1, hello.getOperations().size() );
        
        
        TypeMappingRegistry reg = (TypeMappingRegistry) lookup ( TypeMappingRegistry.ROLE );
        
        TypeMapping tm = reg.getTypeMapping( "urn:Echo" );
        
        assertNotNull( tm );
        
        assertSame( hello.getTypeMapping(), tm );
        
        
        tm = reg.getDefaultTypeMapping();
        
        assertNotNull( tm );
        
        
        Type type = hello.getTypeMapping().getType( String.class );
        
        assertNotNull( type );
        
        type = hello.getTypeMapping().getType( String.class, QName.get( "string", SOAPConstants.XSD) );
        
        assertNotNull( type );
    }
    
    public void testStaticMethods() throws Exception
	{
        AbstractJavaService hello = (AbstractJavaService) lookup( Service.ROLE, "StaticEcho" );

        Collection ops = hello.getOperations();
        assertEquals( 1, ops.size() );
    }
}
