package org.codehaus.xfire.java.document;

import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.java.test.TestHttpTransport;
import org.codehaus.xfire.plexus.PlexusXFireTest;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.WSDL;
import org.dom4j.Document;


/**
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 21, 2004
 */
public class DocumentAutoTypeTest
    extends PlexusXFireTest
{
    public void testBeanService() throws Exception
    {
        Document response = 
            invokeService( "Bean", "/org/codehaus/xfire/java/document/bean11.xml" );

        addNamespace( "sb", "http://test.java.xfire.codehaus.org");
        assertValid( "//sb:out", response );
        assertValid( "//sb:out/sb:howdy[text()=\"howdy\"]", response );
        assertValid( "//sb:out/sb:bleh[text()=\"bleh\"]", response );
    }
    
    public void testBeanServiceWSDL() throws Exception
    {
        TransportManager tm = (TransportManager) lookup( TransportManager.ROLE );
        tm.register( new TestHttpTransport() );
        
        // Test WSDL generation
        Document doc = getWSDLDocument( "Bean" );

        addNamespace( "wsdl", WSDL.WSDL11_NS );
        addNamespace( "wsdlsoap", WSDL.WSDL11_SOAP_NS );
        addNamespace( "xsd", SOAPConstants.XSD );

        assertValid( "/wsdl:definitions/wsdl:types", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType[@name=\"SimpleBean\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType[@name=\"SimpleBean\"]/xsd:sequence/xsd:element[@name=\"bleh\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType[@name=\"SimpleBean\"]/xsd:sequence/xsd:element[@name=\"howdy\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType[@name=\"SimpleBean\"]/xsd:sequence/xsd:element[@type=\"xsd:string\"]", doc );

        assertValid( "/wsdl:definitions/wsdl:service/wsdl:port/wsdlsoap:address[@location=\"http://localhost/services/Bean\"]", doc );
    }
}
