package org.codehaus.xfire.java.mapping;


import junit.framework.TestCase;

import org.codehaus.xfire.java.mapping.CustomTypeMapping;
import org.codehaus.xfire.java.type.StringType;
import org.dom4j.QName;

/**
 * CustomTypeMappingTest
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class CustomTypeMappingTest
    extends TestCase
{
    public void testTM() throws Exception
    {
        CustomTypeMapping mapping = new CustomTypeMapping();
        
        QName qname = QName.get( "String", "urn:soap");
        
        mapping.register( String.class, qname, StringType.class );
        
        assertTrue( mapping.isRegistered( String.class, qname ) );
        
        assertNotNull( mapping.getType( String.class, qname ) );
        
        
        CustomTypeMapping child = new CustomTypeMapping( mapping );
        
        assertTrue( child.isRegistered( String.class, qname ) );
        
        assertNotNull( child.getType( String.class, qname ) );
    }
}
