package org.codehaus.xfire.java.rpcliteral;

import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.java.test.TestHttpTransport;
import org.codehaus.xfire.plexus.PlexusXFireTest;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.WSDL;
import org.dom4j.Document;


/**
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 21, 2004
 */
public class ArrayServiceTest
    extends PlexusXFireTest
{
    public void testBeanService() throws Exception
    {
        Document response = invokeService("Bean", "/org/codehaus/xfire/java/rpcliteral/array11-1.xml" );

        addNamespace( "sb", "urn:Bean" );
        assertValid( "//sb:getBeanArrayResponse/sb:out", response );
        assertValid( "//sb:getBeanArrayResponse/sb:out/sb:SimpleBean[1]/sb:howdy[text()=\"howdy\"]", response );
        assertValid( "//sb:getBeanArrayResponse/sb:out/sb:SimpleBean[1]/sb:bleh[text()=\"bleh\"]", response );
    }
    
    public void testBeanServiceWSDL() throws Exception
    {
        TransportManager tm = (TransportManager) lookup( TransportManager.ROLE );
        tm.register( new TestHttpTransport() );
        
        // Test WSDL generation
        Document doc = getWSDLDocument( "Bean" );

        addNamespace( "wsdl", WSDL.WSDL11_NS );
        addNamespace( "xsd", SOAPConstants.XSD );
        
        assertValid( "/wsdl:definitions/wsdl:types", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema", doc );
        
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:complexType[@name=\"SimpleBean\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:complexType[@name=\"SimpleBean\"]/xsd:sequence/xsd:element[@name=\"bleh\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:complexType[@name=\"SimpleBean\"]/xsd:sequence/xsd:element[@name=\"howdy\"]", doc );
        
        assertValid( "//xsd:complexType[@name=\"ArrayOfString\"]", doc );
        assertValid( "//xsd:complexType[@name=\"ArrayOfString\"]/xsd:sequence/xsd:element[@type=\"xsd:string\"]", doc );
        assertValid( "//xsd:complexType[@name=\"ArrayOfString\"]/xsd:sequence/xsd:element[@name=\"string\"]", doc );
        assertValid( "//xsd:complexType[@name=\"ArrayOfString\"]/xsd:sequence/xsd:element[@minOccurs=\"0\"]", doc );
        assertValid( "//xsd:complexType[@name=\"ArrayOfString\"]/xsd:sequence/xsd:element[@maxOccurs=\"unbounded\"]", doc );
        
        assertValid( "//xsd:complexType[@name=\"ArrayOfBean\"]", doc );
        assertValid( "//xsd:complexType[@name=\"ArrayOfBean\"]/xsd:sequence/xsd:element[@type='tns:SimpleBean'][@name='SimpleBean']", doc );
        assertValid( "//xsd:complexType[@name=\"ArrayOfBean\"]/xsd:sequence/xsd:element[@minOccurs=\"0\"]", doc );
        assertValid( "//xsd:complexType[@name=\"ArrayOfBean\"]/xsd:sequence/xsd:element[@maxOccurs=\"unbounded\"]", doc );
    }
}
