package org.codehaus.xfire.java.types;

import java.util.Date;

import junit.framework.TestCase;

import org.codehaus.xfire.java.message.LiteralReader;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/**
 * DateTest
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class DateTest
	extends TestCase
{
	public void testDates() throws Exception
    {
        SAXReader sax = new SAXReader();
        Document doc = sax.read( getClass().getResourceAsStream( "/org/codehaus/xfire/java/types/dates.xml" ) );
        
        Element root = doc.getRootElement();
        
        LiteralReader reader = new LiteralReader(root);
        Date date0 = reader.getReader("date0").getValueAsDate();
        Date dateTime0 = reader.getReader("dateTime0").getValueAsDateTime();
        Date dateTime1 = reader.getReader("dateTime1").getValueAsDateTime();
        Date dateTime2 = reader.getReader("dateTime2").getValueAsDateTime();
        
        Date dateTime3 = reader.getReader("dateTime3").getValueAsDateTime();
        Date dateTime4 = reader.getReader("dateTime4").getValueAsDateTime();
        assertTrue ( dateTime3.before( dateTime4 ) );
        
        Date dateTime5 = reader.getReader("dateTime5").getValueAsDateTime();
        Date dateTime6 = reader.getReader("dateTime6").getValueAsDateTime();
        assertTrue ( dateTime5.before( dateTime6 ) );
                        
        //Date time0 = reader.getReader("time0").getValueAsTime();
    }
}
